#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgresql-simple
version:              0.6.5.1
visibility:           public
id:                   postgresql-simple-0.6.5.1-L3F3CF4j9DdA9frYugWxnf
key:                  postgresql-simple-0.6.5.1-L3F3CF4j9DdA9frYugWxnf
license:              BSD-3-Clause
copyright:
    (c) 2011 MailRank, Inc.
    (c) 2011-2018 Leon P Smith
    (c) 2018-2020 Oleg Grenrus

maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Bryan O'\''Sullivan, Leon P Smith
synopsis:             Mid-Level PostgreSQL client library
description:
    Mid-Level PostgreSQL client library, forked from mysql-simple.

category:             Database
abi:                  df7de7b3f2d6fd02b9fda6e67528b590
exposed:              True
exposed-modules:
    Database.PostgreSQL.Simple Database.PostgreSQL.Simple.Arrays
    Database.PostgreSQL.Simple.Copy Database.PostgreSQL.Simple.Cursor
    Database.PostgreSQL.Simple.Errors
    Database.PostgreSQL.Simple.FromField
    Database.PostgreSQL.Simple.FromRow
    Database.PostgreSQL.Simple.HStore
    Database.PostgreSQL.Simple.HStore.Internal
    Database.PostgreSQL.Simple.Internal
    Database.PostgreSQL.Simple.LargeObjects
    Database.PostgreSQL.Simple.Newtypes
    Database.PostgreSQL.Simple.Notification
    Database.PostgreSQL.Simple.Ok Database.PostgreSQL.Simple.Range
    Database.PostgreSQL.Simple.SqlQQ Database.PostgreSQL.Simple.Time
    Database.PostgreSQL.Simple.Time.Internal
    Database.PostgreSQL.Simple.ToField Database.PostgreSQL.Simple.ToRow
    Database.PostgreSQL.Simple.Transaction
    Database.PostgreSQL.Simple.TypeInfo
    Database.PostgreSQL.Simple.TypeInfo.Macro
    Database.PostgreSQL.Simple.TypeInfo.Static
    Database.PostgreSQL.Simple.Types Database.PostgreSQL.Simple.Vector
    Database.PostgreSQL.Simple.Vector.Unboxed

hidden-modules:
    Database.PostgreSQL.Simple.Compat
    Database.PostgreSQL.Simple.HStore.Implementation
    Database.PostgreSQL.Simple.Internal.PQResultUtils
    Database.PostgreSQL.Simple.Time.Implementation
    Database.PostgreSQL.Simple.Time.Internal.Parser
    Database.PostgreSQL.Simple.Time.Internal.Printer
    Database.PostgreSQL.Simple.TypeInfo.Types

import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgresql-simple-0.6.5.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgresql-simple-0.6.5.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgresql-simple-0.6.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-postgresql-simple
hs-libraries:         HSpostgresql-simple-0.6.5.1-L3F3CF4j9DdA9frYugWxnf
depends:
    Only-0.1-2ALIOaFTuVl17VyQ33BnR1
    aeson-2.1.2.1-HvDDR856aNq5cfhhuYXFVB
    attoparsec-0.14.4-Kqu9azGoeFY4BlHGbH5HBg base-4.17.2.1
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-9yImpzTIYpBJ0v1fZqtWOj
    containers-0.6.7 hashable-1.4.4.0-EdBgVbn6YIuE9bA3dwmz04
    postgresql-libpq-0.9.5.0-ISIgXFjP19REFuF01eqmjw
    scientific-0.3.8.0-5VCcSe8kMhaKTje3aOa6OL template-haskell-2.19.0.0
    text-2.0.2 time-compat-1.9.7-5r5EVE9BYA2F9wnN6eblWx
    transformers-0.5.6.2 uuid-types-1.0.6-AbsLvP6OB455DAJC5Zy4SR
    vector-0.13.2.0-4gUGda2ISIbCv9ACnxMPCL

haddock-interfaces:
    /usr/share/doc/haskell-postgresql-simple/html/postgresql-simple.haddock

haddock-html:         /usr/share/doc/haskell-postgresql-simple/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

