#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 quickcheck-instances
version:              0.3.32
visibility:           public
id:                   quickcheck-instances-0.3.32-C3ZRaNgcJLAHkJ6ygc4MGq
key:                  quickcheck-instances-0.3.32-C3ZRaNgcJLAHkJ6ygc4MGq
license:              BSD-3-Clause
copyright:            Copyright 2012-2016 Antoine Latter, 2017-2019 Oleg Grenrus
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Antoine Latter <aslatter@gmail.com>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             https://github.com/haskellari/qc-instances
synopsis:             Common quickcheck instances
description:
    QuickCheck instances.

    The goal is to supply QuickCheck instances for
    types provided by the Haskell Platform.

    Since all of these instances are provided as
    orphans, I recommend that you do not use this library
    within another library module, so that you don'\''t
    impose these instances on down-stream consumers of
    your code.

category:             Testing
abi:                  12de1fdb3f1f05a4d197ca321481a103
exposed:              True
exposed-modules:
    Test.QuickCheck.Instances Test.QuickCheck.Instances.Array
    Test.QuickCheck.Instances.Array.Byte
    Test.QuickCheck.Instances.ByteString
    Test.QuickCheck.Instances.CaseInsensitive
    Test.QuickCheck.Instances.Containers
    Test.QuickCheck.Instances.DataFix
    Test.QuickCheck.Instances.Hashable
    Test.QuickCheck.Instances.Natural Test.QuickCheck.Instances.OldTime
    Test.QuickCheck.Instances.Primitive
    Test.QuickCheck.Instances.Scientific
    Test.QuickCheck.Instances.Semigroup Test.QuickCheck.Instances.Solo
    Test.QuickCheck.Instances.Strict Test.QuickCheck.Instances.Tagged
    Test.QuickCheck.Instances.Text Test.QuickCheck.Instances.Text.Short
    Test.QuickCheck.Instances.These Test.QuickCheck.Instances.Time
    Test.QuickCheck.Instances.Transformer
    Test.QuickCheck.Instances.UUID
    Test.QuickCheck.Instances.UnorderedContainers
    Test.QuickCheck.Instances.Vector Test.QuickCheck.Instances.Void

hidden-modules:       Test.QuickCheck.Instances.CustomPrelude
import-dirs:          /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.32
library-dirs:         /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.32
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.32
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-quickcheck-instances
hs-libraries:         HSquickcheck-instances-0.3.32-C3ZRaNgcJLAHkJ6ygc4MGq
depends:
    OneTuple-0.4.2-2brqo3iDSB0Ay4Ml3cesEs
    QuickCheck-2.14.3-BdNvaC7h69h7TPuIdkO7gV array-0.5.4.0
    base-4.17.2.1 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-4gOYP47XUTf2S4ZStIaMwN containers-0.6.7
    data-fix-0.3.4-IY2lXAlldZ275cX4sUP0m2
    hashable-1.4.4.0-GlxcJ9XR4pRDbsSt4txSan
    integer-logarithms-1.0.4-747Qoit3UBvITiwjxAwv8N
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    primitive-0.9.1.0-8CfYwbRaTKl361HTr6YpqL
    scientific-0.3.8.0-FY8DXpomWvN257bBgIbNZf
    splitmix-0.1.1-1ouiqeInllDAfkChmeF360
    strict-0.5-70JwFVCpjZ3C8CdoJYi4qG
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C text-2.0.2
    text-short-0.1.6-LFaRzCZdyShLlrJly9OIQT
    these-1.2.1-BS7oxlcFaTILgb2Y5W01BT
    time-compat-1.9.7-5yM1OuSL6FMEMqV5Mn9CCE transformers-0.5.6.2
    unordered-containers-0.2.20-3ZBRQjn1NdW5zFXXpEAC63
    uuid-types-1.0.6-BJpv36Spp8EkYvmP617IA
    vector-0.13.2.0-1ufxIM0RRngH8NrsSheW9c

haddock-interfaces:
    /usr/share/doc/haskell-quickcheck-instances/html/quickcheck-instances.haddock

haddock-html:         /usr/share/doc/haskell-quickcheck-instances/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

