#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 quickcheck-instances
version:              0.3.33
visibility:           public
id:                   quickcheck-instances-0.3.33-5mLmgxFoTSgEyBhAurNIFv
key:                  quickcheck-instances-0.3.33-5mLmgxFoTSgEyBhAurNIFv
license:              BSD-3-Clause
copyright:            Copyright 2012-2016 Antoine Latter, 2017-2019 Oleg Grenrus
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Antoine Latter <aslatter@gmail.com>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             https://github.com/haskellari/qc-instances
synopsis:             Common quickcheck instances
description:
    QuickCheck instances.

    The goal is to supply QuickCheck instances for
    types provided by the Haskell Platform.

    Since all of these instances are provided as
    orphans, I recommend that you do not use this library
    within another library module, so that you don'\''t
    impose these instances on down-stream consumers of
    your code.

category:             Testing
abi:                  275e04d8be7b6ea5259eddabdc7679e4
exposed:              True
exposed-modules:
    Test.QuickCheck.Instances Test.QuickCheck.Instances.Array
    Test.QuickCheck.Instances.Array.Byte
    Test.QuickCheck.Instances.ByteString
    Test.QuickCheck.Instances.CaseInsensitive
    Test.QuickCheck.Instances.Containers
    Test.QuickCheck.Instances.DataFix
    Test.QuickCheck.Instances.Hashable
    Test.QuickCheck.Instances.Natural Test.QuickCheck.Instances.OldTime
    Test.QuickCheck.Instances.Primitive
    Test.QuickCheck.Instances.Scientific
    Test.QuickCheck.Instances.Semigroup Test.QuickCheck.Instances.Solo
    Test.QuickCheck.Instances.Strict Test.QuickCheck.Instances.Tagged
    Test.QuickCheck.Instances.Text Test.QuickCheck.Instances.Text.Short
    Test.QuickCheck.Instances.These Test.QuickCheck.Instances.Time
    Test.QuickCheck.Instances.Transformer
    Test.QuickCheck.Instances.UUID
    Test.QuickCheck.Instances.UnorderedContainers
    Test.QuickCheck.Instances.Vector Test.QuickCheck.Instances.Void

hidden-modules:       Test.QuickCheck.Instances.CustomPrelude
import-dirs:          /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.33
library-dirs:         /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.33
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.33
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-quickcheck-instances
hs-libraries:         HSquickcheck-instances-0.3.33-5mLmgxFoTSgEyBhAurNIFv
depends:
    OneTuple-0.4.2-AfDBhfzf4f6LoM7aM8JNRh
    QuickCheck-2.15.0.1-BieguRabt0yBi6koHkfIn1 array-0.5.4.0
    base-4.17.2.1 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-2s4OeiMO3UWBaQwGHjklqk containers-0.6.7
    data-fix-0.3.4-EjzgaVMe822wQcgPtXOYx
    hashable-1.4.6.0-Bdyeh8ev81I2bBqnptAVUL
    integer-logarithms-1.0.4-AlDFxKKrdmX8qgRUBpTXQk
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    primitive-0.9.1.0-JdV7LeCcNMFKwvi67SGD5e
    scientific-0.3.8.0-5UF0voSgI45snHwsluIty
    splitmix-0.1.2-7ELmE30QJLcADPJlBluqOq
    strict-0.5-26x4XA3EHZOKf9Adk1xCVf
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C text-2.0.2
    text-short-0.1.6-L2MeS8ccPsd8TFkZJEeMI
    these-1.2.1-5HgiT1SSAxP1wkil8RGMT3
    time-compat-1.9.7-FO69t9RAwVQ39vcN3n6taf transformers-0.5.6.2
    unordered-containers-0.2.20-1s4f8pAJmee27mGfYrIk99
    uuid-types-1.0.6-2UrO6GGyWVrCSnBlkrIl39
    vector-0.13.2.0-JPy5pohpq8EDknIfFhMz6E

haddock-interfaces:
    /usr/share/doc/haskell-quickcheck-instances/html/quickcheck-instances.haddock

haddock-html:         /usr/share/doc/haskell-quickcheck-instances/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

