#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 random
version:              1.2.1.3
visibility:           public
id:                   random-1.2.1.3-FtBkzNFMEVVAWMk0jeYogw
key:                  random-1.2.1.3-FtBkzNFMEVVAWMk0jeYogw
license:              BSD-3-Clause
maintainer:           core-libraries-committee@haskell.org
synopsis:             Pseudo-random number generation
description:
    This package provides basic pseudo-random number generation, including the
    ability to split random number generators.

    == "System.Random": pure pseudo-random number interface

    In pure code, use '\''System.Random.uniform'\'' and '\''System.Random.uniformR'\'' from
    "System.Random" to generate pseudo-random numbers with a pure pseudo-random
    number generator like '\''System.Random.StdGen'\''.

    As an example, here is how you can simulate rolls of a six-sided die using
    '\''System.Random.uniformR'\'':

    >>> let roll = uniformR (1, 6)        :: RandomGen g => g -> (Word, g)
    >>> let rolls = unfoldr (Just . roll) :: RandomGen g => g -> [Word]
    >>> let pureGen = mkStdGen 42
    >>> take 10 (rolls pureGen)           :: [Word]
    [1,1,3,2,4,5,3,4,6,2]

    See "System.Random" for more details.

    == "System.Random.Stateful": monadic pseudo-random number interface

    In monadic code, use '\''System.Random.Stateful.uniformM'\'' and
    '\''System.Random.Stateful.uniformRM'\'' from "System.Random.Stateful" to generate
    pseudo-random numbers with a monadic pseudo-random number generator, or
    using a monadic adapter.

    As an example, here is how you can simulate rolls of a six-sided die using
    '\''System.Random.Stateful.uniformRM'\'':

    >>> let rollM = uniformRM (1, 6)                 :: StatefulGen g m => g -> m Word
    >>> let pureGen = mkStdGen 42
    >>> runStateGen_ pureGen (replicateM 10 . rollM) :: [Word]
    [1,1,3,2,4,5,3,4,6,2]

    The monadic adapter '\''System.Random.Stateful.runStateGen_'\'' is used here to lift
    the pure pseudo-random number generator @pureGen@ into the
    '\''System.Random.Stateful.StatefulGen'\'' context.

    The monadic interface can also be used with existing monadic pseudo-random
    number generators. In this example, we use the one provided in the
    <https://hackage.haskell.org/package/mwc-random mwc-random> package:

    >>> import System.Random.MWC as MWC
    >>> let rollM = uniformRM (1, 6)       :: StatefulGen g m => g -> m Word
    >>> monadicGen <- MWC.create
    >>> replicateM 10 (rollM monadicGen) :: IO [Word]
    [2,3,6,6,4,4,3,1,5,4]

    See "System.Random.Stateful" for more details.

category:             System
abi:                  eb9e7937d9637c3882124d49f28a4f99
exposed:              True
exposed-modules:
    System.Random System.Random.Internal System.Random.Stateful

hidden-modules:       System.Random.GFinite
import-dirs:          /usr/lib/ghc-9.4.8/site-local/random-1.2.1.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/random-1.2.1.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/random-1.2.1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-random
hs-libraries:         HSrandom-1.2.1.3-FtBkzNFMEVVAWMk0jeYogw
depends:
    base-4.17.2.1 bytestring-0.11.5.3 deepseq-1.4.8.0 mtl-2.2.2
    splitmix-0.1.0.5-8qRf11liZLU6wm4qg0dwFp

haddock-interfaces:   /usr/share/doc/haskell-random/html/random.haddock
haddock-html:         /usr/share/doc/haskell-random/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

