#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 Ranged-sets
version:              0.5.0
visibility:           public
id:                   Ranged-sets-0.5.0-2rR5hic30OHCGLuJfsoQWb
key:                  Ranged-sets-0.5.0-2rR5hic30OHCGLuJfsoQWb
license:              BSD-3-Clause
copyright:            Paul Johnson, 2005, 2006, 2007, 2008, 2019, 2025
maintainer:           paul@cogito.org.uk
author:               Paul Johnson
stability:            beta
homepage:             https://github.com/PaulJohnson/Ranged-sets
synopsis:             Ranged sets for Haskell
description:
    A ranged set is an ordered list of ranges.  This allows sets such as all reals x such that:

    > (0.25 < x <= 0.75 or 1.4 <= x < 2.3 or 4.5 < x)

    Alternatively you can have all strings s such that:

    >    ("F" <= s < "G")

category:             Data
abi:                  d7c30d1bdf6b221dc9ca334876d1599e
exposed:              True
exposed-modules:
    Data.Ranged Data.Ranged.Boundaries Data.Ranged.RangedSet
    Data.Ranged.Ranges

import-dirs:          /usr/lib/ghc-9.4.8/site-local/Ranged-sets-0.5.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/Ranged-sets-0.5.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/Ranged-sets-0.5.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ranged-sets
hs-libraries:         HSRanged-sets-0.5.0-2rR5hic30OHCGLuJfsoQWb
depends:
    QuickCheck-2.15.0.1-7dsjbuPrJB87A5nQdB1dNE base-4.17.2.1

haddock-interfaces:   /usr/share/doc/haskell-ranged-sets/html/Ranged-sets.haddock
haddock-html:         /usr/share/doc/haskell-ranged-sets/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

