#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 reflection
version:              2.1.9
visibility:           public
id:                   reflection-2.1.9-KSVNyTXYBkaahcRftxxDO
key:                  reflection-2.1.9-KSVNyTXYBkaahcRftxxDO
license:              BSD-3-Clause
copyright:
    2009-2013 Edward A. Kmett,
    2012 Elliott Hird,
    2004 Oleg Kiselyov and Chung-chieh Shan

maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:
    Edward A. Kmett, Elliott Hird, Oleg Kiselyov and Chung-chieh Shan

stability:            experimental
homepage:             http://github.com/ekmett/reflection
synopsis:
    Reifies arbitrary terms into types that can be reflected back into terms

description:
    This package addresses the /configuration problem/ which is
    propagating configurations that are available at run-time, allowing
    multiple configurations to coexist without resorting to mutable
    global variables or '\''System.IO.Unsafe.unsafePerformIO'\''.

    That package is an implementation of the ideas presented in the
    paper \"Functional Pearl: Implicit Configurations\" by Oleg Kiselyov
    and Chung-chieh Shan (<http://okmij.org/ftp/Haskell/tr-15-04.pdf original paper>).
    However, the API has been streamlined to improve performance.

    There are a handful of tutorials on how to use this library:

    * Austin Seipp'\''s tutorial <https://www.schoolofhaskell.com/user/thoughtpolice/using-reflection Reflecting values to types and back> provides a summary of the
    approach taken by this library, along with more motivating examples.

    * Arnaud Spiwack'\''s tutorial <https://www.tweag.io/posts/2017-12-21-reflection-tutorial.html All about reflection> explains how to use this library.

category:             Data, Reflection, Dependent Types
abi:                  7cf57d7b6405de678601912904197234
exposed:              True
exposed-modules:      Data.Reflection
import-dirs:          /usr/lib/ghc-9.4.8/site-local/reflection-2.1.9
library-dirs:         /usr/lib/ghc-9.4.8/site-local/reflection-2.1.9
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/reflection-2.1.9
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-reflection
hs-libraries:         HSreflection-2.1.9-KSVNyTXYBkaahcRftxxDO
depends:              base-4.17.2.1 template-haskell-2.19.0.0
haddock-interfaces:   /usr/share/doc/haskell-reflection/html/reflection.haddock
haddock-html:         /usr/share/doc/haskell-reflection/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

