#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 regex
version:              1.1.0.2
visibility:           public
id:                   regex-1.1.0.2-G8JfxGHrbJ3FP7rJCLSnWK
key:                  regex-1.1.0.2-G8JfxGHrbJ3FP7rJCLSnWK
license:              BSD-3-Clause
copyright:            Chris Dornan 2016-2017
maintainer:           Chris Dornan <chris@regex.uk>
author:               Chris Dornan
stability:            Stable
homepage:             http://regex.uk
synopsis:             Toolkit for regex-base
description:
    A regular expression toolkit for regex-base with
    compile-time checking of RE syntax, data types for
    matches and captures, a text replacement toolkit,
    portable options, high-level AWK-like tools
    for building text processing apps, regular expression
    macros with parsers and test bench, comprehensive
    documentation, tutorials and copious examples.

category:             Text
abi:                  2b3f60aeb56a24b6ed93bddf8baafbc6
exposed:              True
exposed-modules:
    Text.RE Text.RE.REOptions Text.RE.Replace Text.RE.Summa
    Text.RE.TDFA Text.RE.TDFA.ByteString Text.RE.TDFA.ByteString.Lazy
    Text.RE.TDFA.Sequence Text.RE.TDFA.String Text.RE.TDFA.Text
    Text.RE.TDFA.Text.Lazy Text.RE.TestBench Text.RE.TestBench.Parsers
    Text.RE.Tools Text.RE.Tools.Edit Text.RE.Tools.Find
    Text.RE.Tools.Grep Text.RE.Tools.IsRegex Text.RE.Tools.Lex
    Text.RE.Tools.Sed Text.RE.ZeInternals
    Text.RE.ZeInternals.Types.Poss

hidden-modules:
    Text.RE.ZeInternals.AddCaptureNames
    Text.RE.ZeInternals.EscapeREString
    Text.RE.ZeInternals.NamedCaptures Text.RE.ZeInternals.PreludeMacros
    Text.RE.ZeInternals.QQ Text.RE.ZeInternals.Replace
    Text.RE.ZeInternals.SearchReplace
    Text.RE.ZeInternals.SearchReplace.TDFA
    Text.RE.ZeInternals.SearchReplace.TDFA.ByteString
    Text.RE.ZeInternals.SearchReplace.TDFA.ByteString.Lazy
    Text.RE.ZeInternals.SearchReplace.TDFA.Sequence
    Text.RE.ZeInternals.SearchReplace.TDFA.String
    Text.RE.ZeInternals.SearchReplace.TDFA.Text
    Text.RE.ZeInternals.SearchReplace.TDFA.Text.Lazy
    Text.RE.ZeInternals.SearchReplace.TDFAEdPrime
    Text.RE.ZeInternals.TDFA Text.RE.ZeInternals.TestBench
    Text.RE.ZeInternals.TestBench.Parsers Text.RE.ZeInternals.Tools.Lex
    Text.RE.ZeInternals.Types.Capture
    Text.RE.ZeInternals.Types.CaptureID
    Text.RE.ZeInternals.Types.IsRegex Text.RE.ZeInternals.Types.LineNo
    Text.RE.ZeInternals.Types.Match Text.RE.ZeInternals.Types.Matches
    Text.RE.ZeInternals.Types.SearchReplace

import-dirs:          /usr/lib/ghc-9.4.8/site-local/regex-1.1.0.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/regex-1.1.0.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/regex-1.1.0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-regex
hs-libraries:         HSregex-1.1.0.2-G8JfxGHrbJ3FP7rJCLSnWK
depends:
    array-0.5.4.0 base-4.17.2.1
    base-compat-0.12.3-H9qTMlLoDHsHlMi1O3x7Rp bytestring-0.11.5.3
    containers-0.6.7 hashable-1.4.4.0-1zcla4qwUGf6ADT5z5m7Nb
    regex-base-0.94.0.3-4CB0YhYwj75B1BjBDOnQyh
    regex-pcre-0.95.0.1-5zy7zZE7dd8AnYSlLeRWMw
    regex-tdfa-1.3.2.4-7rACsYAdhMKLNw9nhRxHTR template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2
    unordered-containers-0.2.20-5ChD9TF8iAH5uLARI0QLMz
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-regex/html/regex.haddock
haddock-html:         /usr/share/doc/haskell-regex/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

