#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 reinterpret-cast
version:              0.1.0
visibility:           public
id:                   reinterpret-cast-0.1.0-rJVuXUj4d1IusmWgcXsb1
key:                  reinterpret-cast-0.1.0-rJVuXUj4d1IusmWgcXsb1
license:              MIT
copyright:            2014 Niklas Hambüchen <mail@nh2.me>
maintainer:           Niklas Hambüchen <mail@nh2.me>
author:               Niklas Hambüchen <mail@nh2.me>
stability:            experimental
homepage:             https://github.com/nh2/reinterpret-cast
synopsis:
    Memory reinterpretation casts for Float/Double and Word32/Word64

description:
    Memory reinterpretation casts for Float\/Double and Word32\/Word64.

    The implementations in the @.Internal@ package are different ways to tackle
    the problem; the @array@ method (current default) is about 5 times faster
    than the @FFI@ method.

category:             Data
abi:                  f8d9a739b86e115f499d940ae50e90cc
exposed:              True
exposed-modules:
    Data.ReinterpretCast Data.ReinterpretCast.Internal.ImplArray
    Data.ReinterpretCast.Internal.ImplFFI

import-dirs:          /usr/lib/ghc-9.4.8/site-local/reinterpret-cast-0.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/reinterpret-cast-0.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/reinterpret-cast-0.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-reinterpret-cast
hs-libraries:         HSreinterpret-cast-0.1.0-rJVuXUj4d1IusmWgcXsb1
depends:              array-0.5.4.0 base-4.17.2.1
haddock-interfaces:
    /usr/share/doc/haskell-reinterpret-cast/html/reinterpret-cast.haddock

haddock-html:         /usr/share/doc/haskell-reinterpret-cast/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

