#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 relude
version:              1.2.2.2
visibility:           public
id:                   relude-1.2.2.2-JcIXWeG9YJBFsU7LDakyi1
key:                  relude-1.2.2.2-JcIXWeG9YJBFsU7LDakyi1
license:              MIT
copyright:            2016 Stephen Diehl, 2016-2018 Serokell, 2018-2023 Kowainik
maintainer:           Kowainik <xrom.xkov@gmail.com>
author:
    Dmitrii Kovanikov, Veronika Romashkina, Stephen Diehl, Serokell

stability:            stable
homepage:             https://github.com/kowainik/relude
synopsis:
    Safe, performant, user-friendly and lightweight Haskell Standard Library

description:
    @__relude__@ is an alternative prelude library. If you find the default
    @Prelude@ unsatisfying, despite its advantages, consider using @relude@
    instead.

    == Relude goals and design principles
    * __Productivity.__ You can be more productive with a "non-standard" standard
      library, and @relude@ helps you with writing safer and more
      efficient code faster.

    * __Total programming__. Usage of [/partial functions/](https://www.reddit.com/r/haskell/comments/5n51u3/why_are_partial_functions_as_in_head_tail_bad/)
      can lead to unexpected bugs and runtime exceptions in pure
      code. The types of partial functions lie about their behaviour. And
      even if it is not always possible to rely only on total functions,
      @relude@ strives to encourage best-practices and reduce the
      chances of introducing a bug.

        +---------------------------------+--------------------------------------------+
        | __Partial__                     | __Total__                                  |
        +=================================+============================================+
        | @head :: [a] -> a@              | @head :: NonEmpty a -> a@                  |
        +---------------------------------+--------------------------------------------+
        | @tail :: [a] -> [a]@            | @tail :: NonEmpty a -> [a]@                |
        +---------------------------------+--------------------------------------------+
        | @read :: Read a => String -> a@ | @readMaybe :: Read a => String -> Maybe a@ |
        +---------------------------------+--------------------------------------------+
        | @fromJust :: Maybe a -> a@      | @fromMaybe :: a -> Maybe a -> a@           |
        +---------------------------------+--------------------------------------------+

    * __Type-safety__. We use the /"make invalid states unrepresentable"/ motto as one
      of our guiding principles. If it is possible, we express this concept through the
      types.

        /Example:/ @ whenNotNull :: Applicative f => [a] -> (NonEmpty a -> f ()) -> f () @

    * __Performance.__ We prefer @Text@ over @[String](https://www.reddit.com/r/haskell/comments/29jw0s/whats_wrong_with_string/)@,
      use space-leaks-free functions (e.g. our custom performant @sum@ and @product@),
      introduce @\{\-\# INLINE \#\-\}@ and @\{\-\# SPECIALIZE \#\-\}@ pragmas where
      appropriate, and make efficient container types
      (e.g. @Map@, @HashMap@, @Set@) more accessible.

    * __Minimalism__ (low number of dependencies). We do not force users of
      @relude@ to stick to any specific lens or text formatting or logging
      library. Where possible, @relude@ depends only on boot libraries.
      The [Dependency graph](https://raw.githubusercontent.com/kowainik/relude/main/relude-dependency-graph.png)
      of @relude@ can give you a clearer picture.

    * __Convenience__. Despite minimalism, we want to bring commonly used
       types and functions into scope, and make available functions easier
       to use. Some examples of conveniences:

        1. No need to add @containers@, @unordered-containers@, @text@
           and @bytestring@ to dependencies in your @.cabal@ file to
           use the main API of these libraries
        2. No need to import types like @NonEmpty@, @Text@, @Set@, @Reader[T]@, @MVar@, @STM@
        3. Functions like @liftIO@, @fromMaybe@, @sortWith@ are available by default as well
        4. @IO@ actions are lifted to @MonadIO@

    * __Excellent documentation.__

        1. Tutorial
        2. Migration guide from @Prelude@
        3. Haddock for every function with examples tested by
           [doctest](http://hackage.haskell.org/package/doctest).
        4. Documentation regarding [internal module structure](http://hackage.haskell.org/package/relude/docs/Relude.html)
        5. @relude@-specific [HLint](http://hackage.haskell.org/package/hlint) rules: @[.hlint.yaml](https://github.com/kowainik/relude/blob/main/.hlint.yaml)@

    * __User-friendliness.__ Anyone should be able to quickly migrate to @relude@. Only
      some basic familiarity with the common libraries like @text@ and @containers@
      should be enough (but not necessary).

    * __Exploration.__ We have space to experiment with new ideas and proposals
      without introducing breaking changes. @relude@ uses the approach with
      @Extra.*@ modules which are not exported by default. The chosen approach makes it quite
      easy for us to provide new functionality without breaking anything and let
      the users decide to use it or not.

category:             Prelude
abi:                  33da86f725e2f2f7d73fc4b888be6525
exposed:              True
exposed-modules:
    Data.ByteString from bytestring-0.11.5.3:Data.ByteString,
    Data.ByteString.Builder from bytestring-0.11.5.3:Data.ByteString.Builder,
    Data.ByteString.Lazy from bytestring-0.11.5.3:Data.ByteString.Lazy,
    Data.ByteString.Short from bytestring-0.11.5.3:Data.ByteString.Short,
    Data.HashMap.Lazy from unordered-containers-0.2.20-90liAnN3BtD8VAzg2AGnlq:Data.HashMap.Lazy,
    Data.HashMap.Strict from unordered-containers-0.2.20-90liAnN3BtD8VAzg2AGnlq:Data.HashMap.Strict,
    Data.HashSet from unordered-containers-0.2.20-90liAnN3BtD8VAzg2AGnlq:Data.HashSet,
    Data.IntMap.Lazy from containers-0.6.7:Data.IntMap.Lazy,
    Data.IntMap.Strict from containers-0.6.7:Data.IntMap.Strict,
    Data.IntSet from containers-0.6.7:Data.IntSet,
    Data.Map.Lazy from containers-0.6.7:Data.Map.Lazy,
    Data.Map.Strict from containers-0.6.7:Data.Map.Strict,
    Data.Sequence from containers-0.6.7:Data.Sequence,
    Data.Set from containers-0.6.7:Data.Set,
    Data.Text from text-2.0.2:Data.Text,
    Data.Text.IO from text-2.0.2:Data.Text.IO,
    Data.Text.Lazy from text-2.0.2:Data.Text.Lazy,
    Data.Text.Lazy.IO from text-2.0.2:Data.Text.Lazy.IO,
    Data.Text.Read from text-2.0.2:Data.Text.Read,
    Data.Tree from containers-0.6.7:Data.Tree, Relude,
    Relude.Applicative, Relude.Base, Relude.Bool, Relude.Bool.Guard,
    Relude.Bool.Reexport, Relude.Container, Relude.Container.One,
    Relude.Container.Reexport, Relude.Debug, Relude.DeepSeq,
    Relude.Enum, Relude.Exception, Relude.Extra,
    Relude.Extra.Bifunctor, Relude.Extra.CallStack, Relude.Extra.Enum,
    Relude.Extra.Foldable, Relude.Extra.Foldable1, Relude.Extra.Group,
    Relude.Extra.Lens, Relude.Extra.Map, Relude.Extra.Newtype,
    Relude.Extra.Tuple, Relude.Extra.Type, Relude.File,
    Relude.Foldable, Relude.Foldable.Fold, Relude.Foldable.Reexport,
    Relude.Function, Relude.Functor, Relude.Functor.Fmap,
    Relude.Functor.Reexport, Relude.Lifted, Relude.Lifted.Concurrent,
    Relude.Lifted.Env, Relude.Lifted.Exit, Relude.Lifted.File,
    Relude.Lifted.Handle, Relude.Lifted.IORef, Relude.Lifted.Terminal,
    Relude.List, Relude.List.NonEmpty, Relude.List.Reexport,
    Relude.Monad, Relude.Monad.Either, Relude.Monad.Maybe,
    Relude.Monad.Reexport, Relude.Monad.Trans, Relude.Monoid,
    Relude.Nub, Relude.Numeric, Relude.Print, Relude.String,
    Relude.String.Conversion, Relude.String.Reexport, Relude.Unsafe

import-dirs:          /usr/lib/ghc-9.4.8/site-local/relude-1.2.2.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/relude-1.2.2.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/relude-1.2.2.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-relude
hs-libraries:         HSrelude-1.2.2.2-JcIXWeG9YJBFsU7LDakyi1
depends:
    base-4.17.2.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.0
    ghc-prim-0.9.1 hashable-1.4.4.0-7d9WFDaK31uHgEwdYM8cSb mtl-2.2.2
    stm-2.5.1.0 text-2.0.2 transformers-0.5.6.2
    unordered-containers-0.2.20-90liAnN3BtD8VAzg2AGnlq

haddock-interfaces:   /usr/share/doc/haskell-relude/html/relude.haddock
haddock-html:         /usr/share/doc/haskell-relude/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

