#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 sbv
version:              10.2
visibility:           public
id:                   sbv-10.2-6kLmyeD1huy4JnchLyRIPA
key:                  sbv-10.2-6kLmyeD1huy4JnchLyRIPA
license:              BSD-3-Clause
copyright:            Levent Erkok, 2010-2023
maintainer:           Levent Erkok (erkokl@gmail.com)
author:               Levent Erkok
stability:            Experimental
homepage:             http://leventerkok.github.io/sbv/
synopsis:
    SMT Based Verification: Symbolic Haskell theorem prover using SMT solving.

description:
    Express properties about Haskell programs and automatically prove them using SMT
    (Satisfiability Modulo Theories) solvers.

    For details, please see: <http://leventerkok.github.io/sbv/>

category:
    Formal Methods, Theorem Provers, Bit vectors, Symbolic Computation, Math, SMT

abi:                  6ba373b258700ad41cb5bf5399b312b0
exposed:              True
exposed-modules:
    Data.SBV Data.SBV.Char Data.SBV.Control Data.SBV.Dynamic
    Data.SBV.Either Data.SBV.Float Data.SBV.Internals Data.SBV.List
    Data.SBV.Maybe Data.SBV.Rational Data.SBV.RegExp Data.SBV.Set
    Data.SBV.String Data.SBV.Tools.BMC Data.SBV.Tools.BoundedFix
    Data.SBV.Tools.BoundedList Data.SBV.Tools.CodeGen
    Data.SBV.Tools.GenTest Data.SBV.Tools.Induction
    Data.SBV.Tools.NaturalInduction Data.SBV.Tools.Overflow
    Data.SBV.Tools.Polynomial Data.SBV.Tools.Range Data.SBV.Tools.STree
    Data.SBV.Tools.WeakestPreconditions Data.SBV.Trans
    Data.SBV.Trans.Control Data.SBV.Tuple
    Documentation.SBV.Examples.BitPrecise.BitTricks
    Documentation.SBV.Examples.BitPrecise.BrokenSearch
    Documentation.SBV.Examples.BitPrecise.Legato
    Documentation.SBV.Examples.BitPrecise.MergeSort
    Documentation.SBV.Examples.BitPrecise.MultMask
    Documentation.SBV.Examples.BitPrecise.PrefixSum
    Documentation.SBV.Examples.CodeGeneration.AddSub
    Documentation.SBV.Examples.CodeGeneration.CRC_USB5
    Documentation.SBV.Examples.CodeGeneration.Fibonacci
    Documentation.SBV.Examples.CodeGeneration.GCD
    Documentation.SBV.Examples.CodeGeneration.PopulationCount
    Documentation.SBV.Examples.CodeGeneration.Uninterpreted
    Documentation.SBV.Examples.Crypto.AES
    Documentation.SBV.Examples.Crypto.Prince
    Documentation.SBV.Examples.Crypto.RC4
    Documentation.SBV.Examples.Crypto.SHA
    Documentation.SBV.Examples.DeltaSat.DeltaSat
    Documentation.SBV.Examples.Existentials.CRCPolynomial
    Documentation.SBV.Examples.Existentials.Diophantine
    Documentation.SBV.Examples.Lists.BoundedMutex
    Documentation.SBV.Examples.Lists.CountOutAndTransfer
    Documentation.SBV.Examples.Lists.Fibonacci
    Documentation.SBV.Examples.Lists.Nested
    Documentation.SBV.Examples.Misc.Auxiliary
    Documentation.SBV.Examples.Misc.Definitions
    Documentation.SBV.Examples.Misc.Enumerate
    Documentation.SBV.Examples.Misc.FirstOrderLogic
    Documentation.SBV.Examples.Misc.Floating
    Documentation.SBV.Examples.Misc.LambdaArray
    Documentation.SBV.Examples.Misc.ModelExtract
    Documentation.SBV.Examples.Misc.NestedArray
    Documentation.SBV.Examples.Misc.Newtypes
    Documentation.SBV.Examples.Misc.NoDiv0
    Documentation.SBV.Examples.Misc.Polynomials
    Documentation.SBV.Examples.Misc.SetAlgebra
    Documentation.SBV.Examples.Misc.SoftConstrain
    Documentation.SBV.Examples.Misc.Tuple
    Documentation.SBV.Examples.Optimization.Enumerate
    Documentation.SBV.Examples.Optimization.ExtField
    Documentation.SBV.Examples.Optimization.LinearOpt
    Documentation.SBV.Examples.Optimization.Production
    Documentation.SBV.Examples.Optimization.VM
    Documentation.SBV.Examples.ProofTools.BMC
    Documentation.SBV.Examples.ProofTools.Fibonacci
    Documentation.SBV.Examples.ProofTools.Strengthen
    Documentation.SBV.Examples.ProofTools.Sum
    Documentation.SBV.Examples.Puzzles.AOC_2021_24
    Documentation.SBV.Examples.Puzzles.Birthday
    Documentation.SBV.Examples.Puzzles.Coins
    Documentation.SBV.Examples.Puzzles.Counts
    Documentation.SBV.Examples.Puzzles.DogCatMouse
    Documentation.SBV.Examples.Puzzles.Drinker
    Documentation.SBV.Examples.Puzzles.Euler185
    Documentation.SBV.Examples.Puzzles.Fish
    Documentation.SBV.Examples.Puzzles.Garden
    Documentation.SBV.Examples.Puzzles.HexPuzzle
    Documentation.SBV.Examples.Puzzles.Jugs
    Documentation.SBV.Examples.Puzzles.KnightsAndKnaves
    Documentation.SBV.Examples.Puzzles.LadyAndTigers
    Documentation.SBV.Examples.Puzzles.MagicSquare
    Documentation.SBV.Examples.Puzzles.Murder
    Documentation.SBV.Examples.Puzzles.NQueens
    Documentation.SBV.Examples.Puzzles.Orangutans
    Documentation.SBV.Examples.Puzzles.Rabbits
    Documentation.SBV.Examples.Puzzles.SendMoreMoney
    Documentation.SBV.Examples.Puzzles.Sudoku
    Documentation.SBV.Examples.Puzzles.U2Bridge
    Documentation.SBV.Examples.Queries.Abducts
    Documentation.SBV.Examples.Queries.AllSat
    Documentation.SBV.Examples.Queries.CaseSplit
    Documentation.SBV.Examples.Queries.Concurrency
    Documentation.SBV.Examples.Queries.Enums
    Documentation.SBV.Examples.Queries.FourFours
    Documentation.SBV.Examples.Queries.GuessNumber
    Documentation.SBV.Examples.Queries.Interpolants
    Documentation.SBV.Examples.Queries.UnsatCore
    Documentation.SBV.Examples.Strings.RegexCrossword
    Documentation.SBV.Examples.Strings.SQLInjection
    Documentation.SBV.Examples.Transformers.SymbolicEval
    Documentation.SBV.Examples.Uninterpreted.AUF
    Documentation.SBV.Examples.Uninterpreted.Deduce
    Documentation.SBV.Examples.Uninterpreted.Function
    Documentation.SBV.Examples.Uninterpreted.Multiply
    Documentation.SBV.Examples.Uninterpreted.Shannon
    Documentation.SBV.Examples.Uninterpreted.Sort
    Documentation.SBV.Examples.Uninterpreted.UISortAllSat
    Documentation.SBV.Examples.WeakestPreconditions.Append
    Documentation.SBV.Examples.WeakestPreconditions.Basics
    Documentation.SBV.Examples.WeakestPreconditions.Fib
    Documentation.SBV.Examples.WeakestPreconditions.GCD
    Documentation.SBV.Examples.WeakestPreconditions.IntDiv
    Documentation.SBV.Examples.WeakestPreconditions.IntSqrt
    Documentation.SBV.Examples.WeakestPreconditions.Length
    Documentation.SBV.Examples.WeakestPreconditions.Sum

hidden-modules:
    Data.SBV.Client Data.SBV.Client.BaseIO Data.SBV.Core.AlgReals
    Data.SBV.Core.Concrete Data.SBV.Core.Data Data.SBV.Core.Kind
    Data.SBV.Core.Model Data.SBV.Core.Operations Data.SBV.Core.Floating
    Data.SBV.Core.Sized Data.SBV.Core.SizedFloats
    Data.SBV.Core.Symbolic Data.SBV.Control.BaseIO
    Data.SBV.Control.Query Data.SBV.Control.Types
    Data.SBV.Control.Utils Data.SBV.Compilers.C
    Data.SBV.Compilers.CodeGen Data.SBV.Lambda Data.SBV.SMT.SMT
    Data.SBV.SMT.SMTLib Data.SBV.SMT.SMTLib2 Data.SBV.SMT.SMTLibNames
    Data.SBV.SMT.Utils Data.SBV.Provers.Prover Data.SBV.Provers.ABC
    Data.SBV.Provers.Boolector Data.SBV.Provers.Bitwuzla
    Data.SBV.Provers.CVC4 Data.SBV.Provers.CVC5 Data.SBV.Provers.DReal
    Data.SBV.Provers.MathSAT Data.SBV.Provers.Yices Data.SBV.Provers.Z3
    Data.SBV.Utils.CrackNum Data.SBV.Utils.ExtractIO
    Data.SBV.Utils.Numeric Data.SBV.Utils.TDiff Data.SBV.Utils.Lib
    Data.SBV.Utils.PrettyNum Data.SBV.Utils.SExpr

import-dirs:          /usr/lib/ghc-9.4.8/site-local/sbv-10.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/sbv-10.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/sbv-10.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-sbv
hs-libraries:         HSsbv-10.2-6kLmyeD1huy4JnchLyRIPA
depends:
    QuickCheck-2.14.3-ByUzmICu9MK1GnGhfACscM array-0.5.4.0
    async-2.2.5-8qrDbV8xcFXEsDmo0VTM7z base-4.17.2.1 containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    libBF-0.6.6-GActoePf6jq5lqxzUs5xwB mtl-2.2.2 pretty-1.1.3.6
    process-1.6.18.0 random-1.2.1.3-9I8x2ZdyyN6LUBxcAUCXuW
    syb-0.7.2.4-3MUyG3p3euQLeyQ65NE0AP template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    uniplate-1.6.13-64Z4Yblf70613klrXtpW4Q

haddock-interfaces:   /usr/share/doc/haskell-sbv/html/sbv.haddock
haddock-html:         /usr/share/doc/haskell-sbv/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

