#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 scotty
version:              0.22
visibility:           public
id:                   scotty-0.22-6u9UmG5aFBKH4JMxZfeq7U
key:                  scotty-0.22-6u9UmG5aFBKH4JMxZfeq7U
license:              BSD-3-Clause
copyright:            (c) 2012-Present, Andrew Farmer and the Scotty contributors
maintainer:           The Scotty maintainers
author:               Andrew Farmer <xichekolas@gmail.com>
stability:            experimental
homepage:             https://github.com/scotty-web/scotty
synopsis:
    Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp

description:
    A Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp.

    @
    &#123;-&#35; LANGUAGE OverloadedStrings &#35;-&#125;

    import Web.Scotty

    main = scotty 3000 $
    &#32;&#32;get &#34;/:word&#34; $ do
    &#32;&#32;&#32;&#32;beam <- pathParam &#34;word&#34;
    &#32;&#32;&#32;&#32;html $ mconcat [&#34;&#60;h1&#62;Scotty, &#34;, beam, &#34; me up!&#60;/h1&#62;&#34;]
    @


    Scotty is the cheap and cheerful way to write RESTful, declarative web applications.

    * A page is as simple as defining the verb, url pattern, and Text content.

    * It is template-language agnostic. Anything that returns a Text value will do.

    * Conforms to WAI Application interface.

    * Uses very fast Warp webserver by default.

    As for the name: Sinatra + Warp = Scotty.

    [WAI] <http://hackage.haskell.org/package/wai>

    [Warp] <http://hackage.haskell.org/package/warp>

category:             Web
abi:                  8dff9669fa65ba4ae8c9fd629795f811
exposed:              True
exposed-modules:
    Web.Scotty Web.Scotty.Cookie Web.Scotty.Internal.Types
    Web.Scotty.Trans Web.Scotty.Trans.Strict

hidden-modules:
    Web.Scotty.Action Web.Scotty.Body Web.Scotty.Route
    Web.Scotty.Trans.Lazy Web.Scotty.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/scotty-0.22
library-dirs:         /usr/lib/ghc-9.4.8/site-local/scotty-0.22
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/scotty-0.22
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-scotty
hs-libraries:         HSscotty-0.22-6u9UmG5aFBKH4JMxZfeq7U
depends:
    aeson-2.1.2.1-4ODQ1UQyjV4HqW8vjPOsEA base-4.17.2.1
    blaze-builder-0.4.4-9Y3q4YsfSJE9aDeePNxCbC bytestring-0.11.5.3
    case-insensitive-1.2.1.0-6fVgEt7vrFc1sDHTeWeWXd
    cookie-0.4.6-GZOZqzUDn152OuhEYvht8s
    data-default-class-0.1.2.1-J2UCuIureY5CbnU1SgrtGb exceptions-0.10.5
    http-types-0.12.4-ALPJWcgMeIc83stb9QW9Gl
    monad-control-1.0.3.1-8hRw9mjLBLl6PAQlNWysTu mtl-2.2.2
    network-3.1.4.0-9ZkyLgutzTZFWrHs4BgIgX
    regex-compat-0.95.2.2-XQpODnagAHFJ9GlOSqau8
    resourcet-1.2.6-1DDiq5XD7CWDw9CwnQya4j stm-2.5.1.0 text-2.0.2
    time-1.12.2 transformers-0.5.6.2
    transformers-base-0.4.6-9k6sqnTM6dd156kd3yeDl4
    unliftio-0.2.25.1-HM0R1ty4e2TDt6fGDzBedX
    wai-3.2.4-1yop7BvplydTH1djBo1do
    wai-extra-3.1.17-BqkJjRoAdGnJ0inpYtyqgr
    warp-3.3.30-8OpZYlaRw56DjKQnzqAXnQ

haddock-interfaces:   /usr/share/doc/haskell-scotty/html/scotty.haddock
haddock-html:         /usr/share/doc/haskell-scotty/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

