#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 scotty
version:              0.22
visibility:           public
id:                   scotty-0.22-DT7O411O5mV1I3Iy7OD7YD
key:                  scotty-0.22-DT7O411O5mV1I3Iy7OD7YD
license:              BSD-3-Clause
copyright:            (c) 2012-Present, Andrew Farmer and the Scotty contributors
maintainer:           The Scotty maintainers
author:               Andrew Farmer <xichekolas@gmail.com>
stability:            experimental
homepage:             https://github.com/scotty-web/scotty
synopsis:
    Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp

description:
    A Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp.

    @
    &#123;-&#35; LANGUAGE OverloadedStrings &#35;-&#125;

    import Web.Scotty

    main = scotty 3000 $
    &#32;&#32;get &#34;/:word&#34; $ do
    &#32;&#32;&#32;&#32;beam <- pathParam &#34;word&#34;
    &#32;&#32;&#32;&#32;html $ mconcat [&#34;&#60;h1&#62;Scotty, &#34;, beam, &#34; me up!&#60;/h1&#62;&#34;]
    @


    Scotty is the cheap and cheerful way to write RESTful, declarative web applications.

    * A page is as simple as defining the verb, url pattern, and Text content.

    * It is template-language agnostic. Anything that returns a Text value will do.

    * Conforms to WAI Application interface.

    * Uses very fast Warp webserver by default.

    As for the name: Sinatra + Warp = Scotty.

    [WAI] <http://hackage.haskell.org/package/wai>

    [Warp] <http://hackage.haskell.org/package/warp>

category:             Web
abi:                  b15b1848733c9df0106d6c40e0a550c4
exposed:              True
exposed-modules:
    Web.Scotty Web.Scotty.Cookie Web.Scotty.Internal.Types
    Web.Scotty.Trans Web.Scotty.Trans.Strict

hidden-modules:
    Web.Scotty.Action Web.Scotty.Body Web.Scotty.Route
    Web.Scotty.Trans.Lazy Web.Scotty.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/scotty-0.22
library-dirs:         /usr/lib/ghc-9.4.8/site-local/scotty-0.22
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/scotty-0.22
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-scotty
hs-libraries:         HSscotty-0.22-DT7O411O5mV1I3Iy7OD7YD
depends:
    aeson-2.1.2.1-wY4CXNP4Ti6TCaMY1tyMf base-4.17.2.1
    blaze-builder-0.4.4-hpTW57LOkJwByfG1pJQ0 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-A6Av13j1PriHVZgHNthY8h
    cookie-0.4.6-4shfaVKBFn0Hnep1ZY6FZw
    data-default-class-0.1.2.2-2EcHBs5cfSFLku8331ZnRi exceptions-0.10.5
    http-types-0.12.4-75PPyaYnKWt41SOfuGm1SN
    monad-control-1.0.3.1-5MkAM4FLEyHGYqORCXEDzl mtl-2.2.2
    network-3.1.4.0-18zdZgmnDKE1J4Hp557YCB
    regex-compat-0.95.2.2-XQpODnagAHFJ9GlOSqau8
    resourcet-1.2.6-3ZqxfisK1jQJQLApAB05ya stm-2.5.1.0 text-2.0.2
    time-1.12.2 transformers-0.5.6.2
    transformers-base-0.4.6-Hst2ZvVN1773HZEalQop5t
    unliftio-0.2.25.1-JkBrfFhIPgO7yJ2PXMSkPF
    wai-3.2.4-4DSUxPBVo3aDU1FL8Kb4AX
    wai-extra-3.1.17-7sOIMyXdW19GMJAKYRA1MK
    warp-3.3.30-L8efBONiiYN1bELlbKsQBo

haddock-interfaces:   /usr/share/doc/haskell-scotty/html/scotty.haddock
haddock-html:         /usr/share/doc/haskell-scotty/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

