#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 scotty
version:              0.22
visibility:           public
id:                   scotty-0.22-DNk2JyzifW8BdrKBjZTaKS
key:                  scotty-0.22-DNk2JyzifW8BdrKBjZTaKS
license:              BSD-3-Clause
copyright:            (c) 2012-Present, Andrew Farmer and the Scotty contributors
maintainer:           The Scotty maintainers
author:               Andrew Farmer <xichekolas@gmail.com>
stability:            experimental
homepage:             https://github.com/scotty-web/scotty
synopsis:
    Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp

description:
    A Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp.

    @
    &#123;-&#35; LANGUAGE OverloadedStrings &#35;-&#125;

    import Web.Scotty

    main = scotty 3000 $
    &#32;&#32;get &#34;/:word&#34; $ do
    &#32;&#32;&#32;&#32;beam <- pathParam &#34;word&#34;
    &#32;&#32;&#32;&#32;html $ mconcat [&#34;&#60;h1&#62;Scotty, &#34;, beam, &#34; me up!&#60;/h1&#62;&#34;]
    @


    Scotty is the cheap and cheerful way to write RESTful, declarative web applications.

    * A page is as simple as defining the verb, url pattern, and Text content.

    * It is template-language agnostic. Anything that returns a Text value will do.

    * Conforms to WAI Application interface.

    * Uses very fast Warp webserver by default.

    As for the name: Sinatra + Warp = Scotty.

    [WAI] <http://hackage.haskell.org/package/wai>

    [Warp] <http://hackage.haskell.org/package/warp>

category:             Web
abi:                  dd1110c964851a9ccba82d5ba840014d
exposed:              True
exposed-modules:
    Web.Scotty Web.Scotty.Cookie Web.Scotty.Internal.Types
    Web.Scotty.Trans Web.Scotty.Trans.Strict

hidden-modules:
    Web.Scotty.Action Web.Scotty.Body Web.Scotty.Route
    Web.Scotty.Trans.Lazy Web.Scotty.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/scotty-0.22
library-dirs:         /usr/lib/ghc-9.4.8/site-local/scotty-0.22
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/scotty-0.22
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-scotty
hs-libraries:         HSscotty-0.22-DNk2JyzifW8BdrKBjZTaKS
depends:
    aeson-2.1.2.1-4RB85zdNr5p3whZ1np3a31 base-4.17.2.1
    blaze-builder-0.4.4.1-BSmLbvNejToLEWeTg2SNQj bytestring-0.11.5.3
    case-insensitive-1.2.1.0-LYFsGNYxHzcJNUKypl8Xr7
    cookie-0.4.6-4shfaVKBFn0Hnep1ZY6FZw
    data-default-class-0.1.2.2-2EcHBs5cfSFLku8331ZnRi exceptions-0.10.5
    http-types-0.12.4-Jx04LytKDQxAS6dwQTH9Cw
    monad-control-1.0.3.1-EOtuqgiA6ZEDGkogoPMFkv mtl-2.2.2
    network-3.1.4.0-KCu1LDB4kGQHeeCsiSLoOZ
    regex-compat-0.95.2.2-XQpODnagAHFJ9GlOSqau8
    resourcet-1.2.6-2WPOMAIVFIM62rtu43cRpf stm-2.5.1.0 text-2.0.2
    time-1.12.2 transformers-0.5.6.2
    transformers-base-0.4.6-JDPbHOCRzwQHUSPopl5OnX
    unliftio-0.2.25.1-3Yhh17ZiDqL8wBy06T4Fv
    wai-3.2.4-HB9yxc5cWSY3PjQANbUXrV
    wai-extra-3.1.18-HGqKFbiDRfyJOYUe4j6hWW
    warp-3.3.30-6NKX59beJQBK1qUf1zNclk

haddock-interfaces:   /usr/share/doc/haskell-scotty/html/scotty.haddock
haddock-html:         /usr/share/doc/haskell-scotty/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

