#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 scotty
version:              0.22
visibility:           public
id:                   scotty-0.22-7cf2TNSiYsSFplsL2fIpzA
key:                  scotty-0.22-7cf2TNSiYsSFplsL2fIpzA
license:              BSD-3-Clause
copyright:            (c) 2012-Present, Andrew Farmer and the Scotty contributors
maintainer:           The Scotty maintainers
author:               Andrew Farmer <xichekolas@gmail.com>
stability:            experimental
homepage:             https://github.com/scotty-web/scotty
synopsis:
    Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp

description:
    A Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp.

    @
    &#123;-&#35; LANGUAGE OverloadedStrings &#35;-&#125;

    import Web.Scotty

    main = scotty 3000 $
    &#32;&#32;get &#34;/:word&#34; $ do
    &#32;&#32;&#32;&#32;beam <- pathParam &#34;word&#34;
    &#32;&#32;&#32;&#32;html $ mconcat [&#34;&#60;h1&#62;Scotty, &#34;, beam, &#34; me up!&#60;/h1&#62;&#34;]
    @


    Scotty is the cheap and cheerful way to write RESTful, declarative web applications.

    * A page is as simple as defining the verb, url pattern, and Text content.

    * It is template-language agnostic. Anything that returns a Text value will do.

    * Conforms to WAI Application interface.

    * Uses very fast Warp webserver by default.

    As for the name: Sinatra + Warp = Scotty.

    [WAI] <http://hackage.haskell.org/package/wai>

    [Warp] <http://hackage.haskell.org/package/warp>

category:             Web
abi:                  ac67abff07998a81963239159e3f549c
exposed:              True
exposed-modules:
    Web.Scotty Web.Scotty.Cookie Web.Scotty.Internal.Types
    Web.Scotty.Trans Web.Scotty.Trans.Strict

hidden-modules:
    Web.Scotty.Action Web.Scotty.Body Web.Scotty.Route
    Web.Scotty.Trans.Lazy Web.Scotty.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/scotty-0.22
library-dirs:         /usr/lib/ghc-9.4.8/site-local/scotty-0.22
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/scotty-0.22
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-scotty
hs-libraries:         HSscotty-0.22-7cf2TNSiYsSFplsL2fIpzA
depends:
    aeson-2.1.2.1-3LOl3stht3x9JybSpHkoQT base-4.17.2.1
    blaze-builder-0.4.4.1-HxVSWkAf6gu1L6Fw7VU2pX bytestring-0.11.5.3
    case-insensitive-1.2.1.0-DLRBsz9VfqUNwIWg4HsHR
    cookie-0.5.0-Khxmud11aHE2bTuo1AKBzI
    data-default-class-0.1.2.2-2EcHBs5cfSFLku8331ZnRi exceptions-0.10.5
    http-types-0.12.4-6ojMayzAfwB91OTgOklzJ2
    monad-control-1.0.3.1-LSLhupPVMts1T2xDzCbm7z mtl-2.2.2
    network-3.1.4.0-1n8WDlzhAQUHYfqI16mYdv
    regex-compat-0.95.2.2-XQpODnagAHFJ9GlOSqau8
    resourcet-1.2.6-BjVvYpvovCOJ16EMcKLjlI stm-2.5.1.0 text-2.0.2
    time-1.12.2 transformers-0.5.6.2
    transformers-base-0.4.6-9a385SIdm505uSRtbGh5Pa
    unliftio-0.2.25.1-2icaVFExB3i9p5Bi6oB2UY
    wai-3.2.4-HXL0p0WqRSGJXNDZnyl0Hj
    wai-extra-3.1.18-a3N8VoGXAg5KBaSqy8NBc
    warp-3.4.0-9odkFZsHMyT9nAjq8C8gI1

haddock-interfaces:   /usr/share/doc/haskell-scotty/html/scotty.haddock
haddock-html:         /usr/share/doc/haskell-scotty/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

