#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 semialign
version:              1.3.1
visibility:           public
id:                   semialign-1.3.1-Dk9aD5bDstBLqIZG95oLbr
key:                  semialign-1.3.1-Dk9aD5bDstBLqIZG95oLbr
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               C. McCann, Oleg Grenrus
homepage:             https://github.com/haskellari/these
synopsis:
    Align and Zip type-classes from the common Semialign ancestor.

description:
    The major use of @These@ of this is provided by the @align@ member of
    @Semialign@ class, representing a generalized notion of "zipping with padding"
    that combines structures without truncating to the size of the smaller input.

    It turns out that @zip@ operation fits well the @Semialign@ class,
    forming lattice-like structure.

category:             Data, These
abi:                  bb382509801de7a3c905f6b8610683a4
exposed:              True
exposed-modules:
    Data.Align Data.Crosswalk Data.Semialign Data.Semialign.Indexed
    Data.Zip

hidden-modules:       Data.Semialign.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/semialign-1.3.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/semialign-1.3.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/semialign-1.3.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-semialign
hs-libraries:         HSsemialign-1.3.1-Dk9aD5bDstBLqIZG95oLbr
depends:
    base-4.17.2.1 containers-0.6.7
    hashable-1.4.4.0-5SoCNaysfySGuPwu0aljBu
    indexed-traversable-0.1.4-32owkfOBjPeHHjn6v5P4Ru
    indexed-traversable-instances-0.1.2-G35rdN0Y5pdDndJCz2SZOx
    semigroupoids-6.0.1-Ajxt1MUD1pH7gUEFlchfjE
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C
    these-1.2.1-1NEeGX2jWKNBNb0xrVz49O transformers-0.5.6.2
    unordered-containers-0.2.20-AeV3HTkHtCc6BQ9fzLSSB8
    vector-0.13.2.0-52P7Ozt5w3I6hi4WvheJB9

haddock-interfaces:   /usr/share/doc/haskell-semialign/html/semialign.haddock
haddock-html:         /usr/share/doc/haskell-semialign/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

