#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 semialign
version:              1.3.1
visibility:           public
id:                   semialign-1.3.1-5H4UyuOWoTu1UdZkX900T3
key:                  semialign-1.3.1-5H4UyuOWoTu1UdZkX900T3
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               C. McCann, Oleg Grenrus
homepage:             https://github.com/haskellari/these
synopsis:
    Align and Zip type-classes from the common Semialign ancestor.

description:
    The major use of @These@ of this is provided by the @align@ member of
    @Semialign@ class, representing a generalized notion of "zipping with padding"
    that combines structures without truncating to the size of the smaller input.

    It turns out that @zip@ operation fits well the @Semialign@ class,
    forming lattice-like structure.

category:             Data, These
abi:                  c742080587bad86088e77f71d8a55ccd
exposed:              True
exposed-modules:
    Data.Align Data.Crosswalk Data.Semialign Data.Semialign.Indexed
    Data.Zip

hidden-modules:       Data.Semialign.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/semialign-1.3.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/semialign-1.3.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/semialign-1.3.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-semialign
hs-libraries:         HSsemialign-1.3.1-5H4UyuOWoTu1UdZkX900T3
depends:
    base-4.17.2.1 containers-0.6.7
    hashable-1.4.4.0-2lvxXC6j7O5I2GR31C0SqX
    indexed-traversable-0.1.4-LyeF3yLPY26FCcc6uHtQva
    indexed-traversable-instances-0.1.2-5PEjsSGwM9x9Nqd5eMJHfr
    semigroupoids-6.0.1-6UDNhnrCcmB8qcD4TESfdi
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C
    these-1.2.1-A1iF20SJCyz2l4WDICkAUH transformers-0.5.6.2
    unordered-containers-0.2.20-G9Xtyt8hv5K8HhfrH8JX1r
    vector-0.13.2.0-K0fBmK5qd7y3388236ZS0A

haddock-interfaces:   /usr/share/doc/haskell-semialign/html/semialign.haddock
haddock-html:         /usr/share/doc/haskell-semialign/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

