#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 serialise
version:              0.2.6.1
visibility:           public
id:                   serialise-0.2.6.1-3Tf4eprYiV1Cc88mGJH0qS
key:                  serialise-0.2.6.1-3Tf4eprYiV1Cc88mGJH0qS
license:              BSD-3-Clause
copyright:
    2015-2017 Duncan Coutts,
    2015-2017 Well-Typed LLP,
    2015 IRIS Connect Ltd

maintainer:           duncan@community.haskell.org, ben@smart-cactus.org
author:               Duncan Coutts
homepage:             https://github.com/well-typed/cborg
synopsis:             A binary serialisation library for Haskell values.
description:
    This package (formerly @binary-serialise-cbor@) provides pure, efficient
    serialization of Haskell values directly into @ByteString@s for storage or
    transmission purposes. By providing a set of type class instances, you can
    also serialise any custom data type you have as well.

    The underlying binary format used is the '\''Concise Binary Object
    Representation'\'', or CBOR, specified in RFC 7049. As a result,
    serialised Haskell values have implicit structure outside of the
    Haskell program itself, meaning they can be inspected or analyzed
    without custom tools.

    An implementation of the standard bijection between CBOR and JSON is provided
    by the [cborg-json](/package/cborg-json) package. Also see
    [cbor-tool](/package/cbor-tool) for a convenient command-line utility for
    working with CBOR data.

category:             Codec
abi:                  c523117bd7b8435aaba79e83bbb9e4d3
exposed:              True
exposed-modules:
    Codec.Serialise Codec.Serialise.Class Codec.Serialise.Decoding
    Codec.Serialise.Encoding Codec.Serialise.IO
    Codec.Serialise.Internal.GeneralisedUTF8 Codec.Serialise.Properties
    Codec.Serialise.Tutorial

import-dirs:          /usr/lib/ghc-9.4.8/site-local/serialise-0.2.6.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/serialise-0.2.6.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/serialise-0.2.6.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-serialise
hs-libraries:         HSserialise-0.2.6.1-3Tf4eprYiV1Cc88mGJH0qS
depends:
    array-0.5.4.0 base-4.17.2.1 bytestring-0.11.5.3
    cborg-0.2.10.0-HoTQioXVkvwBSRZ40X7TvC containers-0.6.7
    ghc-prim-0.9.1 half-0.3.3-JPRDflLMac5p6YERd0GYl
    hashable-1.4.6.0-8MG0S5dfyXU6lRGLMgbs1l
    primitive-0.9.1.0-BPFoIcduUog2ja2MaonOAo
    strict-0.5-6fp74gBmFCzCkSWcfcTB3y text-2.0.2
    these-1.2.1-8mrzQA4ZRRj2d4hazdVbNv time-1.12.2
    unordered-containers-0.2.20-Iia3zhz8DVL3Efh3E6ja96
    vector-0.13.2.0-89nHvRrlFmk5zBBEvFgHzR

haddock-interfaces:   /usr/share/doc/haskell-serialise/html/serialise.haddock
haddock-html:         /usr/share/doc/haskell-serialise/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

