#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 servant-swagger
version:              1.2.1
visibility:           public
id:                   servant-swagger-1.2.1-DqkKZajEWi7JGEa95Sgfmn
key:                  servant-swagger-1.2.1-DqkKZajEWi7JGEa95Sgfmn
license:              BSD-3-Clause
copyright:            (c) 2015-2018, Servant contributors
maintainer:           haskell-servant-maintainers@googlegroups.com
author:               Servant Contributors
homepage:
    https://github.com/haskell-servant/servant/tree/master/servant-swagger#readme

synopsis:
    Generate a Swagger/OpenAPI/OAS 2.0 specification for your servant API.

description:
    Swagger is a project used to describe and document RESTful APIs. The core of the
    project is the [OpenAPI Specification (OAS)](https://swagger.io/docs/specification/about/).
    This library implements v2.0 of the spec. Unlike Servant it is language-agnostic and thus is
    quite popular among developers in different languages. It has also existed for a longer time
    and has more helpful tooling.

    This package provides means to generate a Swagger/OAS specification for a Servant API
    and also to partially test whether an API conforms with its specification.

    Generated Swagger specification then can be used for many things such as

    * displaying interactive documentation using [Swagger UI](http://swagger.io/swagger-ui/);

    * generating clients and servers in many languages using [Swagger Codegen](http://swagger.io/swagger-codegen/);

    * and [many others](http://swagger.io/open-source-integrations/).

category:             Web, Servant, Swagger
abi:                  164c4f56dba28cd5bd041c9475939040
exposed:              True
exposed-modules:
    Servant.Swagger Servant.Swagger.Internal
    Servant.Swagger.Internal.Orphans Servant.Swagger.Internal.Test
    Servant.Swagger.Internal.TypeLevel
    Servant.Swagger.Internal.TypeLevel.API
    Servant.Swagger.Internal.TypeLevel.Every
    Servant.Swagger.Internal.TypeLevel.TMap Servant.Swagger.Test
    Servant.Swagger.TypeLevel

import-dirs:          /usr/lib/ghc-9.4.8/site-local/servant-swagger-1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/servant-swagger-1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/servant-swagger-1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-servant-swagger
hs-libraries:         HSservant-swagger-1.2.1-DqkKZajEWi7JGEa95Sgfmn
depends:
    QuickCheck-2.14.3-J45WF0Yux319EMk6f3cLwH
    aeson-2.1.2.1-Eu0ZMA1fvZJ7acphaZ1YUp
    aeson-pretty-0.8.10-8K6VAOlgEiI6kbxgmBEhWH base-4.17.2.1
    base-compat-0.13.1-8jgXJjtFto7AX0ry1QXDcA bytestring-0.11.5.3
    hspec-2.11.0.1-2eE4SMEtb24CqoCsM4thi0
    http-media-0.8.1.1-8uDE1LVwBQG8pjkw28yYI5
    insert-ordered-containers-0.2.5.3-2fZfudvxd7RJ9mrOHVaUe0
    lens-5.3.1-58EqPfReeF86v3dzDdfR9b
    servant-0.20.3.0-EuzmrbVYAb29vCD4LJtCFZ
    singleton-bool-0.1.8-6L4mTy3hoR6EAtjajDsXi5
    swagger2-2.8.10-5MmNEraD4Gv9jHEEnPNsnx text-2.0.2
    unordered-containers-0.2.20-5YE9FG6zPmjDjdA4DCPpEY

haddock-interfaces:
    /usr/share/doc/haskell-servant-swagger/html/servant-swagger.haddock

haddock-html:         /usr/share/doc/haskell-servant-swagger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

