#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 servant-swagger
version:              1.2.1
visibility:           public
id:                   servant-swagger-1.2.1-DQY1pqsylPh305qVmGWVWv
key:                  servant-swagger-1.2.1-DQY1pqsylPh305qVmGWVWv
license:              BSD-3-Clause
copyright:            (c) 2015-2018, Servant contributors
maintainer:           haskell-servant-maintainers@googlegroups.com
author:               Servant Contributors
homepage:
    https://github.com/haskell-servant/servant/tree/master/servant-swagger#readme

synopsis:
    Generate a Swagger/OpenAPI/OAS 2.0 specification for your servant API.

description:
    Swagger is a project used to describe and document RESTful APIs. The core of the
    project is the [OpenAPI Specification (OAS)](https://swagger.io/docs/specification/about/).
    This library implements v2.0 of the spec. Unlike Servant it is language-agnostic and thus is
    quite popular among developers in different languages. It has also existed for a longer time
    and has more helpful tooling.

    This package provides means to generate a Swagger/OAS specification for a Servant API
    and also to partially test whether an API conforms with its specification.

    Generated Swagger specification then can be used for many things such as

    * displaying interactive documentation using [Swagger UI](http://swagger.io/swagger-ui/);

    * generating clients and servers in many languages using [Swagger Codegen](http://swagger.io/swagger-codegen/);

    * and [many others](http://swagger.io/open-source-integrations/).

category:             Web, Servant, Swagger
abi:                  582ef5397500991cb81d08f17e06d05c
exposed:              True
exposed-modules:
    Servant.Swagger Servant.Swagger.Internal
    Servant.Swagger.Internal.Orphans Servant.Swagger.Internal.Test
    Servant.Swagger.Internal.TypeLevel
    Servant.Swagger.Internal.TypeLevel.API
    Servant.Swagger.Internal.TypeLevel.Every
    Servant.Swagger.Internal.TypeLevel.TMap Servant.Swagger.Test
    Servant.Swagger.TypeLevel

import-dirs:          /usr/lib/ghc-9.4.8/site-local/servant-swagger-1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/servant-swagger-1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/servant-swagger-1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-servant-swagger
hs-libraries:         HSservant-swagger-1.2.1-DQY1pqsylPh305qVmGWVWv
depends:
    QuickCheck-2.15.0.1-4O3a6KCv0r3IEepy258gow
    aeson-2.1.2.1-U8Qicry0zF1f9E1tHxOto
    aeson-pretty-0.8.10-4zjwdGc7xq045iIhkhi3FG base-4.17.2.1
    base-compat-0.13.1-8jgXJjtFto7AX0ry1QXDcA bytestring-0.11.5.3
    hspec-2.11.0.1-9Wwr4Gy8Dh9L51n4qncJuJ
    http-media-0.8.1.1-C1yKVIRmbNSG9AvmkGitxA
    insert-ordered-containers-0.2.5.3-EdY0IPOLTmR8K2lwvIJO1g
    lens-5.3.1-GXFgjSkl7U7Fy6s0hRmBiy
    servant-0.20.3.0-K4IwAaQz0tYCbVYUzVqkFC
    singleton-bool-0.1.8-1prs7lAXqBpEq5BjCdLZDw
    swagger2-2.8.10-IIaNwRijnuIFC5gLIGCaqY text-2.0.2
    unordered-containers-0.2.20-KWLixwBKCEK6ORqUSVo2CW

haddock-interfaces:
    /usr/share/doc/haskell-servant-swagger/html/servant-swagger.haddock

haddock-html:         /usr/share/doc/haskell-servant-swagger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

