#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 servant-swagger
version:              1.2.1
visibility:           public
id:                   servant-swagger-1.2.1-F2IL6Pi6zKs52HzFNUrkQB
key:                  servant-swagger-1.2.1-F2IL6Pi6zKs52HzFNUrkQB
license:              BSD-3-Clause
copyright:            (c) 2015-2018, Servant contributors
maintainer:           haskell-servant-maintainers@googlegroups.com
author:               Servant Contributors
homepage:
    https://github.com/haskell-servant/servant/tree/master/servant-swagger#readme

synopsis:
    Generate a Swagger/OpenAPI/OAS 2.0 specification for your servant API.

description:
    Swagger is a project used to describe and document RESTful APIs. The core of the
    project is the [OpenAPI Specification (OAS)](https://swagger.io/docs/specification/about/).
    This library implements v2.0 of the spec. Unlike Servant it is language-agnostic and thus is
    quite popular among developers in different languages. It has also existed for a longer time
    and has more helpful tooling.

    This package provides means to generate a Swagger/OAS specification for a Servant API
    and also to partially test whether an API conforms with its specification.

    Generated Swagger specification then can be used for many things such as

    * displaying interactive documentation using [Swagger UI](http://swagger.io/swagger-ui/);

    * generating clients and servers in many languages using [Swagger Codegen](http://swagger.io/swagger-codegen/);

    * and [many others](http://swagger.io/open-source-integrations/).

category:             Web, Servant, Swagger
abi:                  3a9c3ff240d0485fe1f9ae79b0cc0f45
exposed:              True
exposed-modules:
    Servant.Swagger Servant.Swagger.Internal
    Servant.Swagger.Internal.Orphans Servant.Swagger.Internal.Test
    Servant.Swagger.Internal.TypeLevel
    Servant.Swagger.Internal.TypeLevel.API
    Servant.Swagger.Internal.TypeLevel.Every
    Servant.Swagger.Internal.TypeLevel.TMap Servant.Swagger.Test
    Servant.Swagger.TypeLevel

import-dirs:          /usr/lib/ghc-9.4.8/site-local/servant-swagger-1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/servant-swagger-1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/servant-swagger-1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-servant-swagger
hs-libraries:         HSservant-swagger-1.2.1-F2IL6Pi6zKs52HzFNUrkQB
depends:
    QuickCheck-2.14.3-4HbOe3sBZbX6PbIkQ49pGG
    aeson-2.1.2.1-JD8QPsoBF4NC1qVY6ch6us
    aeson-pretty-0.8.10-6Jj4MhYvGcCJDG7KnnBAWa base-4.17.2.1
    base-compat-0.13.0-4bY7VGgUDQwFnN0OMsXbDp bytestring-0.11.5.3
    hspec-2.11.0-CSR0phsx7ZQKOBVMSbfouE
    http-media-0.8.1.1-BPrwXBmjufGEfFDVOVZ0m6
    insert-ordered-containers-0.2.5.3-FteEgKmOrlWKJTzg9pbnhM
    lens-5.3.1-JV4NgTTRRUD4MjO8VGr2iB
    servant-0.20.2-B5vIwqF6z89EshIYRO3TZD
    singleton-bool-0.1.8-CMN7dOcbLhl1dZMQkKMnLX
    swagger2-2.8.10-5gDOdyfb8j0Eahp6r9IWhA text-2.0.2
    unordered-containers-0.2.20-ASGEyX3xTBf3ZK5sYSGlF8

haddock-interfaces:
    /usr/share/doc/haskell-servant-swagger/html/servant-swagger.haddock

haddock-html:         /usr/share/doc/haskell-servant-swagger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

