#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 skylighting-core
version:              0.14.2
visibility:           public
id:                   skylighting-core-0.14.2-7TvSOn7bQ1g1foidT8RVZt
key:                  skylighting-core-0.14.2-7TvSOn7bQ1g1foidT8RVZt
license:              BSD-3-Clause
copyright:            (C) 2016-2024 John MacFarlane
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
homepage:             https://github.com/jgm/skylighting
synopsis:             syntax highlighting library
description:
    Skylighting is a syntax highlighting library.
    It derives its tokenizers from XML syntax
    definitions used by KDE'\''s KSyntaxHighlighting
    framework, so any syntax supported by that
    framework can be added. An optional command-line
    program is provided.
    Skylighting is intended to be the successor to
    highlighting-kate.
    This package provides the core highlighting
    functionality under a permissive license. It also
    bundles XML parser definitions licensed under the
    GPL.

category:             Text
abi:                  0cbd767c1b270e5940204f8788d53007
exposed:              True
exposed-modules:
    Skylighting.Core Skylighting.Loader Skylighting.Parser
    Skylighting.Regex Skylighting.Styles Skylighting.Tokenizer
    Skylighting.Types

hidden-modules:
    Regex.KDE Regex.KDE.Regex Regex.KDE.Compile Regex.KDE.Match

import-dirs:          /usr/lib/ghc-9.4.8/site-local/skylighting-core-0.14.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/skylighting-core-0.14.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/skylighting-core-0.14.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-skylighting-core
hs-libraries:         HSskylighting-core-0.14.2-7TvSOn7bQ1g1foidT8RVZt
depends:
    aeson-2.1.2.1-6ANjbGmrSDg8K6hz3VmYXP
    attoparsec-0.14.4-G1kY79wp4BCwb0EQHIFQA base-4.17.2.1
    base64-bytestring-1.2.1.0-9TOa4ZiPzZCEZmYgmgxjAh binary-0.8.9.1
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-IP68CV0DvpE446u5n94xId
    colour-2.3.6-FtNV6vIncLUA7QVvan4Sl4 containers-0.6.7
    directory-1.3.7.1 filepath-1.4.2.2 mtl-2.2.2
    safe-0.3.21-95M34uAYizmIkn1zPFtQ36 text-2.0.2 transformers-0.5.6.2
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    xml-conduit-1.9.1.4-7lMJqvbIlhi6eIKtmmElnZ

haddock-interfaces:
    /usr/share/doc/haskell-skylighting-core/html/skylighting-core.haddock

haddock-html:         /usr/share/doc/haskell-skylighting-core/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

