#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 snap-core
version:              1.0.5.1
visibility:           public
id:                   snap-core-1.0.5.1-HkMXjhD74D0LNpLPHllpXR
key:                  snap-core-1.0.5.1-HkMXjhD74D0LNpLPHllpXR
license:              BSD-3-Clause
maintainer:           snap@snapframework.com
author:               Snap Framework Authors (see CONTRIBUTORS)
homepage:             http://snapframework.com/
synopsis:             Snap: A Haskell Web Framework (core interfaces and types)
description:
    Snap is a simple and fast web development framework and server written in
    Haskell. For more information or to download the latest version, you can
    visit the Snap project website at <http://snapframework.com/>.

    This library contains the core definitions and types for the Snap framework,
    including:

    1. Primitive types and functions for HTTP (requests, responses, cookies,
    post/query parameters, etc)

    2. A monad for programming web handlers called \"Snap\", which allows:

    * Stateful access to the HTTP request and response objects

    * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
    to handle requests and chaining handlers together

    * Early termination of the computation if you know early what you want
    to return and want to prevent further monadic processing

    /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Core".

category:             Web, Snap, IO-Streams
abi:                  4d5598c188facf2cb7128ad39e91767a
exposed:              True
exposed-modules:
    Snap.Core Snap.Internal.Core Snap.Internal.Debug
    Snap.Internal.Http.Types Snap.Internal.Parsing
    Snap.Internal.Util.FileServe Snap.Test Snap.Types.Headers
    Snap.Util.CORS Snap.Util.FileServe Snap.Util.FileUploads
    Snap.Util.GZip Snap.Util.Proxy

hidden-modules:
    Snap.Internal.Instances Snap.Internal.Routing
    Snap.Internal.Test.RequestBuilder Snap.Internal.Test.Assertions
    Snap.Internal.Util.FileUploads

import-dirs:          /usr/lib/ghc-9.4.8/site-local/snap-core-1.0.5.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/snap-core-1.0.5.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/snap-core-1.0.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-snap-core
hs-libraries:         HSsnap-core-1.0.5.1-HkMXjhD74D0LNpLPHllpXR
depends:
    HUnit-1.6.2.0-DUvlqmsw2Kp6tCDRl9WtXA
    attoparsec-0.14.4-KCzcP2UZhdCHukFfOxO6Y base-4.17.2.1
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-HQ3spM7mAjfDZxqIURCldM
    containers-0.6.7 directory-1.3.7.1 filepath-1.4.2.2
    hashable-1.4.4.0-E3AlBtIk95ULiiCgr6U6fg
    io-streams-1.5.2.2-JoA8QQJ1eLs94LJiLpxj2G
    lifted-base-0.2.3.12-5SrZw1LPstqBtGlP8dFdT9
    monad-control-1.0.3.1-BVpkB5Wn7nM3apHk8mZe6N mtl-2.2.2
    network-3.1.4.0-ItBhIFDvz12FCCKfYobIMX
    network-uri-2.6.4.2-Ej2S5J8Z0oCB2cTGXU0OdX
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    random-1.2.1.3-1epqCSzcS4p5bPWcI4Ab0S
    readable-0.3.1-IDsQMpnz7oHK9VbHbSIfA7
    regex-posix-0.96.0.2-AHNuIP1Pa8gKU2TxlSaYg9 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 transformers-base-0.4.6-5fNBcOsjucmLbhbzO5v2Ph
    unix-compat-0.7.4.1-IVg4e2FKApqEytJ5iwZzXw
    unordered-containers-0.2.20-Ee1qJYwM3Cx9FXWFU8Ujy3
    vector-0.13.2.0-cop25r7TnE5vewvd3oOyK

haddock-interfaces:   /usr/share/doc/haskell-snap-core/html/snap-core.haddock
haddock-html:         /usr/share/doc/haskell-snap-core/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

