#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 snap-core
version:              1.0.5.1
visibility:           public
id:                   snap-core-1.0.5.1-4JmFJtEtyAkHzcIlUAEqpk
key:                  snap-core-1.0.5.1-4JmFJtEtyAkHzcIlUAEqpk
license:              BSD-3-Clause
maintainer:           snap@snapframework.com
author:               Snap Framework Authors (see CONTRIBUTORS)
homepage:             http://snapframework.com/
synopsis:             Snap: A Haskell Web Framework (core interfaces and types)
description:
    Snap is a simple and fast web development framework and server written in
    Haskell. For more information or to download the latest version, you can
    visit the Snap project website at <http://snapframework.com/>.

    This library contains the core definitions and types for the Snap framework,
    including:

    1. Primitive types and functions for HTTP (requests, responses, cookies,
    post/query parameters, etc)

    2. A monad for programming web handlers called \"Snap\", which allows:

    * Stateful access to the HTTP request and response objects

    * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
    to handle requests and chaining handlers together

    * Early termination of the computation if you know early what you want
    to return and want to prevent further monadic processing

    /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Core".

category:             Web, Snap, IO-Streams
abi:                  30c10588764aa20b64d478fb3bd6c93f
exposed:              True
exposed-modules:
    Snap.Core Snap.Internal.Core Snap.Internal.Debug
    Snap.Internal.Http.Types Snap.Internal.Parsing
    Snap.Internal.Util.FileServe Snap.Test Snap.Types.Headers
    Snap.Util.CORS Snap.Util.FileServe Snap.Util.FileUploads
    Snap.Util.GZip Snap.Util.Proxy

hidden-modules:
    Snap.Internal.Instances Snap.Internal.Routing
    Snap.Internal.Test.RequestBuilder Snap.Internal.Test.Assertions
    Snap.Internal.Util.FileUploads

import-dirs:          /usr/lib/ghc-9.4.8/site-local/snap-core-1.0.5.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/snap-core-1.0.5.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/snap-core-1.0.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-snap-core
hs-libraries:         HSsnap-core-1.0.5.1-4JmFJtEtyAkHzcIlUAEqpk
depends:
    HUnit-1.6.2.0-DUvlqmsw2Kp6tCDRl9WtXA
    attoparsec-0.14.4-GTfBnxih117FV8L70A8efO base-4.17.2.1
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-A6Av13j1PriHVZgHNthY8h
    containers-0.6.7 directory-1.3.7.1 filepath-1.4.2.2
    hashable-1.4.4.0-ER9qsIVdqB66mmnPytAzi1
    io-streams-1.5.2.2-8WxGGOdhQXw4sy96sU5wUm
    lifted-base-0.2.3.12-EFbwanK1P9o3GJ3p4h9ilC
    monad-control-1.0.3.1-5MkAM4FLEyHGYqORCXEDzl mtl-2.2.2
    network-3.1.4.0-18zdZgmnDKE1J4Hp557YCB
    network-uri-2.6.4.2-95fWnkSq4twGVejB9ewxKe
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    random-1.2.1.3-7z4mPLTBPidE9rbVioKqnW
    readable-0.3.1-IDsQMpnz7oHK9VbHbSIfA7
    regex-posix-0.96.0.2-AHNuIP1Pa8gKU2TxlSaYg9 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 transformers-base-0.4.6-Hst2ZvVN1773HZEalQop5t
    unix-compat-0.7.4.1-KxuMsRfldAv3o1PX9QN6ga
    unordered-containers-0.2.20-BdnqkwZm9bx6ocoMK9HG74
    vector-0.13.2.0-B5pfN7kp2sVHpMWItbJQ58

haddock-interfaces:   /usr/share/doc/haskell-snap-core/html/snap-core.haddock
haddock-html:         /usr/share/doc/haskell-snap-core/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

