#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 haskell-src-exts
version:              1.23.1
visibility:           public
id:                   haskell-src-exts-1.23.1-Is3ARqgINFqFlx7av1ivyg
key:                  haskell-src-exts-1.23.1-Is3ARqgINFqFlx7av1ivyg
license:              BSD-3-Clause
maintainer:           Dan Burton <danburton.email@gmail.com>
author:               Niklas Broberg
stability:            Stable
homepage:             https://github.com/haskell-suite/haskell-src-exts
synopsis:
    Manipulating Haskell source: abstract syntax, lexer, parser, and pretty-printer

description:
    Haskell-Source with Extensions (HSE, haskell-src-exts)
    is a standalone parser for Haskell. In addition to
    standard Haskell, all extensions implemented in GHC are supported.

    Apart from these standard extensions,
    it also handles regular patterns as per the HaRP extension
    as well as HSX-style embedded XML syntax.

category:             Language
abi:                  ecac9d1aa69d2ee886ea21b40e04d7ca
exposed:              True
exposed-modules:
    Language.Haskell.Exts Language.Haskell.Exts.Build
    Language.Haskell.Exts.Comments Language.Haskell.Exts.ExactPrint
    Language.Haskell.Exts.Extension Language.Haskell.Exts.Fixity
    Language.Haskell.Exts.Lexer Language.Haskell.Exts.Parser
    Language.Haskell.Exts.Pretty Language.Haskell.Exts.SrcLoc
    Language.Haskell.Exts.Syntax

hidden-modules:
    Language.Haskell.Exts.ExtScheme Language.Haskell.Exts.ParseMonad
    Language.Haskell.Exts.ParseSyntax
    Language.Haskell.Exts.InternalLexer
    Language.Haskell.Exts.ParseUtils
    Language.Haskell.Exts.InternalParser Language.Preprocessor.Unlit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/haskell-src-exts-1.23.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/haskell-src-exts-1.23.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/haskell-src-exts-1.23.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-src-exts
hs-libraries:         HShaskell-src-exts-1.23.1-Is3ARqgINFqFlx7av1ivyg
depends:
    array-0.5.4.0 base-4.17.2.1 ghc-prim-0.9.1 pretty-1.1.3.6

haddock-interfaces:
    /usr/share/doc/haskell-src-exts/html/haskell-src-exts.haddock

haddock-html:         /usr/share/doc/haskell-src-exts/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

