#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 statistics
version:              0.16.3.0
visibility:           public
id:                   statistics-0.16.3.0-IG8JAhWki7UHIcO3ZBAxZM
key:                  statistics-0.16.3.0-IG8JAhWki7UHIcO3ZBAxZM
license:              BSD-2-Clause
copyright:            2009-2014 Bryan O'\''Sullivan
maintainer:           Alexey Khudaykov <alexey.skladnoy@gmail.com>
author:
    Bryan O'\''Sullivan <bos@serpentine.com>, Alexey Khudaykov <alexey.skladnoy@gmail.com>

homepage:             https://github.com/haskell/statistics
synopsis:             A library of statistical types, data, and functions
description:
    This library provides a number of common functions and types useful
    in statistics.  We focus on high performance, numerical robustness,
    and use of good algorithms.  Where possible, we provide
    references to the statistical literature.
    .
    The library'\''s facilities can be divided into four broad categories:
    .
    * Working with widely used discrete and continuous probability
      distributions.  (There are dozens of exotic distributions in use;
      we focus on the most common.)
    .
    * Computing with sample data: quantile estimation, kernel density
      estimation, histograms, bootstrap methods, significance testing,
      and regression and autocorrelation analysis.
    .
    * Random variate generation under several different distributions.
    .
    * Common statistical tests for significant differences between
      samples.

category:             Math, Statistics
abi:                  aa7a3c111abd9242c24c534191f23e38
exposed:              True
exposed-modules:
    Statistics.Autocorrelation Statistics.ConfidenceInt
    Statistics.Correlation Statistics.Correlation.Kendall
    Statistics.Distribution Statistics.Distribution.Beta
    Statistics.Distribution.Binomial
    Statistics.Distribution.CauchyLorentz
    Statistics.Distribution.ChiSquared
    Statistics.Distribution.DiscreteUniform
    Statistics.Distribution.Exponential
    Statistics.Distribution.FDistribution Statistics.Distribution.Gamma
    Statistics.Distribution.Geometric
    Statistics.Distribution.Hypergeometric
    Statistics.Distribution.Laplace Statistics.Distribution.Lognormal
    Statistics.Distribution.NegativeBinomial
    Statistics.Distribution.Normal Statistics.Distribution.Poisson
    Statistics.Distribution.StudentT Statistics.Distribution.Transform
    Statistics.Distribution.Uniform Statistics.Distribution.Weibull
    Statistics.Function Statistics.Quantile Statistics.Regression
    Statistics.Resampling Statistics.Resampling.Bootstrap
    Statistics.Sample Statistics.Sample.Histogram
    Statistics.Sample.Internal Statistics.Sample.KernelDensity
    Statistics.Sample.KernelDensity.Simple Statistics.Sample.Normalize
    Statistics.Sample.Powers Statistics.Test.ChiSquared
    Statistics.Test.KolmogorovSmirnov Statistics.Test.KruskalWallis
    Statistics.Test.MannWhitneyU Statistics.Test.StudentT
    Statistics.Test.Types Statistics.Test.WilcoxonT
    Statistics.Transform Statistics.Types

hidden-modules:
    Statistics.Distribution.Poisson.Internal Statistics.Internal
    Statistics.Test.Internal Statistics.Types.Internal

import-dirs:          /usr/lib/ghc-9.4.8/site-local/statistics-0.16.3.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/statistics-0.16.3.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/statistics-0.16.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-statistics
hs-libraries:         HSstatistics-0.16.3.0-IG8JAhWki7UHIcO3ZBAxZM
depends:
    aeson-2.1.2.1-LvJWrHbVhNW5j5NGQeCpIT
    async-2.2.5-GA6qhjC24ND8PxBPqYF6rT base-4.17.2.1 binary-0.8.9.1
    data-default-class-0.1.2.2-2EcHBs5cfSFLku8331ZnRi deepseq-1.4.8.0
    dense-linear-algebra-0.1.0.0-8cXN5w1XvyNCKuuEI37ZiR
    math-functions-0.3.4.4-FiRMA599lzm7ijpnshtXbj
    mwc-random-0.15.2.0-L0urSZ6p4cH8hYVp4wcV4B
    parallel-3.2.2.0-KJ5o3ImR3G8wdLWLqGjpy
    primitive-0.9.1.0-F4HGYkgYEkOLs7asiZIPNd
    random-1.2.1.3-FjAccEVuGQcK7S7DSNXHmd
    vector-0.13.2.0-7jLyylqham1Ij3AknS5IxU
    vector-algorithms-0.9.1.0-90Lc5guwwBpLtvolcvKuad
    vector-binary-instances-0.2.5.2-CJ4ZgxlSFCmBQIyt1xuOjo
    vector-th-unbox-0.2.2-8UoSZfHh5wMIULCViyFBTf

haddock-interfaces:   /usr/share/doc/haskell-statistics/html/statistics.haddock
haddock-html:         /usr/share/doc/haskell-statistics/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

