#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 stm-containers
version:              1.2.1.1
visibility:           public
id:                   stm-containers-1.2.1.1-FlMXSkVESPx62KbVJA99Ey
key:                  stm-containers-1.2.1.1-FlMXSkVESPx62KbVJA99Ey
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/stm-containers
synopsis:             Containers for STM
description:
    This library is based on an STM-specialized implementation of
    Hash Array Mapped Trie.
    It provides efficient implementations of @Map@, @Set@
    and other data structures,
    which starting from version @1@ perform even better than their counterparts from \"unordered-containers\",
    but also scale well on concurrent access patterns.
    .
    For details on performance of the library, which are a bit outdated, see
    <http://nikita-volkov.github.io/stm-containers/ this blog post>.

category:             Data Structures, STM, Concurrency
abi:                  963e0823e7d86a81b81cc59ee68cafb5
exposed:              True
exposed-modules:
    StmContainers.Bimap StmContainers.Map StmContainers.Multimap
    StmContainers.Set

hidden-modules:       StmContainers.Prelude
import-dirs:          /usr/lib/ghc-9.4.8/site-local/stm-containers-1.2.1.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/stm-containers-1.2.1.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/stm-containers-1.2.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-stm-containers
hs-libraries:         HSstm-containers-1.2.1.1-FlMXSkVESPx62KbVJA99Ey
depends:
    base-4.17.2.1 deferred-folds-0.9.18.7-8qzz5gTMwhDkEMQCCY7ZX
    focus-1.0.3.2-L3sGob6rGOYE2S7cgSYcM0
    hashable-1.4.4.0-7d9WFDaK31uHgEwdYM8cSb
    list-t-1.0.5.7-83bnWLiUkpA55ljp9Oyvvl
    stm-hamt-1.2.1.1-9fS4b08YcGV5zIG3fs5hzC transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-stm-containers/html/stm-containers.haddock

haddock-html:         /usr/share/doc/haskell-stm-containers/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

