#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 stm-delay
version:              0.1.1.2
visibility:           public
id:                   stm-delay-0.1.1.2-Ja2Pyr1W2WB4UTwmdnCx6d
key:                  stm-delay-0.1.1.2-Ja2Pyr1W2WB4UTwmdnCx6d
license:              BSD-3-Clause
copyright:            Copyright (c) Joseph Adams 2012
maintainer:           joeyadams3.14159@gmail.com
author:               Joey Adams
homepage:             https://github.com/joeyadams/haskell-stm-delay
synopsis:             Updatable one-shot timer polled with STM
description:
    This library lets you create a one-shot timer, poll it using STM,
    and update it to ring at a different time than initially specified.

    It uses GHC event manager timeouts when available
    (GHC 7.2+, @-threaded@, non-Windows OS), yielding performance similar
    to @threadDelay@ and @registerDelay@.  Otherwise, it falls back to
    forked threads and @threadDelay@.

    [0.1.1.2 (2025-05-08)]

    - Remove a call to ensureIOManagerIsRunning, for consistency with System.Timeout

    - Adjust timings in the testsuite to fix intermittent failure in the non-threaded RTS case.

    [0.1.1 (2014-09-14)]

    - Add tryWaitDelayIO, improve performance for certain cases of @newDelay@
    and @updateDelay@, and improve example.

category:             System
abi:                  a08b5a1fb2ffaae18f26163033093c92
exposed:              True
exposed-modules:      Control.Concurrent.STM.Delay
import-dirs:          /usr/lib/ghc-9.6.6/site-local/stm-delay-0.1.1.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/stm-delay-0.1.1.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/stm-delay-0.1.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-stm-delay
hs-libraries:         HSstm-delay-0.1.1.2-Ja2Pyr1W2WB4UTwmdnCx6d
depends:              base-4.18.2.1 stm-2.5.1.0
haddock-interfaces:   /usr/share/doc/haskell-stm-delay/html/stm-delay.haddock
haddock-html:         /usr/share/doc/haskell-stm-delay/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

