#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-accountability
version:              1.10.0
visibility:           public
id:                   tamarin-prover-accountability-1.10.0-HL1dHvMQrNxFH4FRUT6zpz
key:                  tamarin-prover-accountability-1.10.0-HL1dHvMQrNxFH4FRUT6zpz
license:              LicenseRef-GPL
copyright:            (c) 2019-2021 Robert Künnemann, Kevin Morio & Yavor Ivanov
maintainer:           Robert Künnemann <robert@kunnemann.de>
author:
    Robert Künnemann <robert@kunnemann.de>,
    Kevin Morio <kevin.morio@cispa.de>,
    Yavor Ivanov <yavor.ivanov@cispa.de>

homepage:             https://tamarin-prover.github.io/
synopsis:             Library for accountability for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides support for accountability verification.

category:             Theorem Provers
abi:                  51f8dd773ec7f251d0f96d86a9741079
exposed:              True
exposed-modules:      Accountability Accountability.Generation
import-dirs:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

library-dirs:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

library-dirs-static:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-accountability
hs-libraries:
    HStamarin-prover-accountability-1.10.0-HL1dHvMQrNxFH4FRUT6zpz

depends:
    aeson-2.1.2.1-CM1TyKExMgH6p2KQqrdDHD
    aeson-pretty-0.8.10-3WCsO9UEOFd53JyI5jmmw7 base-4.17.2.1
    binary-0.8.9.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.0
    dlist-1.0-4JevPcHjuIUFMGxCSM81ml exceptions-0.10.5
    fclabels-2.0.5.1-BRzztS5WkqbJyzStq1THW2 mtl-2.2.2
    parallel-3.2.2.0-KJ5o3ImR3G8wdLWLqGjpy parsec-3.1.16.1
    process-1.6.18.0 raw-strings-qq-1.1-73kb7SizjX3bDDbE8dc5y
    safe-0.3.21-2QfDol6D5mJHd9hpTIyjO0
    tamarin-prover-term-1.10.0-2FZH0Hq96MpDS43nZnEpA8
    tamarin-prover-theory-1.10.0-8StyBs3SQRm1owMaXUyo7e
    tamarin-prover-utils-1.10.0-Gs2yNeLpCl0E3Jfe4uKJMW text-2.0.2
    transformers-0.5.6.2 uniplate-1.6.13-ImZCoiwUv6aBXZj92EL9Mk

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-accountability/html/tamarin-prover-accountability.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-accountability/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

