#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-accountability
version:              1.10.0
visibility:           public
id:                   tamarin-prover-accountability-1.10.0-Fhx4A2JLUDX8BH9cOe26iT
key:                  tamarin-prover-accountability-1.10.0-Fhx4A2JLUDX8BH9cOe26iT
license:              LicenseRef-GPL
copyright:            (c) 2019-2021 Robert Künnemann, Kevin Morio & Yavor Ivanov
maintainer:           Robert Künnemann <robert@kunnemann.de>
author:
    Robert Künnemann <robert@kunnemann.de>,
    Kevin Morio <kevin.morio@cispa.de>,
    Yavor Ivanov <yavor.ivanov@cispa.de>

homepage:             https://tamarin-prover.github.io/
synopsis:             Library for accountability for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides support for accountability verification.

category:             Theorem Provers
abi:                  0503fd9a85265e665b908b46547dcd81
exposed:              True
exposed-modules:      Accountability Accountability.Generation
import-dirs:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

library-dirs:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

library-dirs-static:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-accountability
hs-libraries:
    HStamarin-prover-accountability-1.10.0-Fhx4A2JLUDX8BH9cOe26iT

depends:
    aeson-2.1.2.1-IUt8ms8F4mK1p5ihNOaPfT
    aeson-pretty-0.8.10-K7jcODCkr7JIW9rVvc0MRD base-4.17.2.1
    binary-0.8.9.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.0
    dlist-1.0-E99MqJW5mmB4kr4PCgIESI exceptions-0.10.5
    fclabels-2.0.5.1-J3vKsWFRchn1Ok2mdrjAxF mtl-2.2.2
    parallel-3.2.2.0-KJ5o3ImR3G8wdLWLqGjpy parsec-3.1.16.1
    process-1.6.18.0 raw-strings-qq-1.1-2iPYOBdGpdOF42mL2GmaQ2
    safe-0.3.21-JSgKJ1qQ11UGSifs2bSHTA
    tamarin-prover-term-1.10.0-KipYX5rCoJL8X9ZpxRf3Qv
    tamarin-prover-theory-1.10.0-IBFMDvRaDE2EIT171HREaX
    tamarin-prover-utils-1.10.0-EgLCAGZag8XB38Dg1rn7zA text-2.0.2
    transformers-0.5.6.2 uniplate-1.6.13-KFVJHXYBZ8v9rbo2IibCdk

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-accountability/html/tamarin-prover-accountability.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-accountability/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

