#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-sapic
version:              1.10.0
visibility:           public
id:                   tamarin-prover-sapic-1.10.0-9mVpdWn0WSMEa8qgvUXGgd
key:                  tamarin-prover-sapic-1.10.0-9mVpdWn0WSMEa8qgvUXGgd
license:              LicenseRef-GPL
copyright:
    Robert Künnemann, Alexander Dax, CISPA-Helmholtz-Centre Saarbrücken, 2019

maintainer:           Robert Künnemann <robert@kunnemann.de>
author:
    Robert Künnemann <robert@kunnemann.de>,
    Alexander Dax <alexander.dax@cispa.saarland>

homepage:             https://tamarin-prover.github.io/
synopsis:
    Library for input processes in SAPIC calculus for the tamarin prover.

description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides a translation from processes stated in the SAPIC calculus into multiset rewrite rules.

category:             Theorem Provers
abi:                  e056cb66935d63a666bbd40d0bc10e2a
exposed:              True
exposed-modules:
    Sapic Sapic.Annotation Sapic.Basetranslation Sapic.Bindings
    Sapic.Compression Sapic.Exceptions Sapic.Facts Sapic.LetDestructors
    Sapic.Locks Sapic.ProcessUtils Sapic.ProgressFunction
    Sapic.ProgressTranslation Sapic.ReliableChannelTranslation
    Sapic.Report Sapic.SecretChannels Sapic.States Sapic.Typing
    Sapic.Warnings

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tamarin-prover-sapic-1.10.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tamarin-prover-sapic-1.10.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tamarin-prover-sapic-1.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-sapic
hs-libraries:         HStamarin-prover-sapic-1.10.0-9mVpdWn0WSMEa8qgvUXGgd
depends:
    aeson-2.1.2.1-9rGsBPhyshTKvPzkopJx8r
    aeson-pretty-0.8.10-FoZoq2L63jY6PFOqAzdYHf base-4.17.2.1
    binary-0.8.9.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.0
    dlist-1.0-E99MqJW5mmB4kr4PCgIESI exceptions-0.10.5
    fclabels-2.0.5.1-8fTjJBL5KlbIP9HgvSKwJd mtl-2.2.2
    parallel-3.2.2.0-KJ5o3ImR3G8wdLWLqGjpy parsec-3.1.16.1
    process-1.6.18.0 raw-strings-qq-1.1-73kb7SizjX3bDDbE8dc5y
    safe-0.3.21-h7eXfPvXuk1aMCYRfiuDr
    tamarin-prover-term-1.10.0-49bntf5ZpUcL2ffxkmyQIi
    tamarin-prover-theory-1.10.0-BqFCU09oIMR1s2EaLJDM4L
    tamarin-prover-utils-1.10.0-6DYeUxtPkgCDaKfxrDkhIS text-2.0.2
    transformers-0.5.6.2 uniplate-1.6.13-2egmD8nimLnDndRlz9dOHZ

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-sapic/html/tamarin-prover-sapic.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-sapic/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

