#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tasty
version:              1.5
visibility:           public
id:                   tasty-1.5-KfqPODqIxWIB9zLnFruxu2
key:                  tasty-1.5-KfqPODqIxWIB9zLnFruxu2
license:              MIT
maintainer:           Roman Cheplyaka <roma@ro-che.info>
author:               Roman Cheplyaka <roma@ro-che.info>
homepage:             https://github.com/UnkindPartition/tasty
synopsis:             Modern and extensible testing framework
description:
    Tasty is a modern testing framework for Haskell.
    It lets you combine your unit tests, golden
    tests, QuickCheck/SmallCheck properties, and any
    other types of tests into a single test suite.

category:             Testing
abi:                  2ea96f13968dd55821c5682f57b6b1ac
exposed:              True
exposed-modules:
    Test.Tasty Test.Tasty.Ingredients Test.Tasty.Ingredients.Basic
    Test.Tasty.Ingredients.ConsoleReporter Test.Tasty.Options
    Test.Tasty.Patterns.Eval Test.Tasty.Patterns.Parser
    Test.Tasty.Patterns.Printer Test.Tasty.Patterns.Types
    Test.Tasty.Providers Test.Tasty.Providers.ConsoleFormat
    Test.Tasty.Runners

hidden-modules:
    Control.Concurrent.Async Test.Tasty.Parallel Test.Tasty.Core
    Test.Tasty.Options.Core Test.Tasty.Options.Env Test.Tasty.Patterns
    Test.Tasty.Patterns.Expr Test.Tasty.Run Test.Tasty.Runners.Reducers
    Test.Tasty.Runners.Utils Test.Tasty.CmdLine
    Test.Tasty.Ingredients.ListTests
    Test.Tasty.Ingredients.IncludingOptions

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tasty-1.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tasty-1.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tasty-1.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tasty
hs-libraries:         HStasty-1.5-KfqPODqIxWIB9zLnFruxu2
depends:
    ansi-terminal-1.0.2-5rU4pkSh0boE3ReNmRQ6hH base-4.17.2.1
    containers-0.6.7
    optparse-applicative-0.18.1.0-5pRc89gLzX8JqTyOujyDZt stm-2.5.1.0
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C transformers-0.5.6.2 unix-2.7.3

haddock-interfaces:   /usr/share/doc/haskell-tasty/html/tasty.haddock
haddock-html:         /usr/share/doc/haskell-tasty/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

