#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 text-ansi
version:              0.3.0.1
visibility:           public
id:                   text-ansi-0.3.0.1-I9GwyqPMgH1LmHNz6r7fu0
key:                  text-ansi-0.3.0.1-I9GwyqPMgH1LmHNz6r7fu0
license:              BSD-3-Clause
copyright:            (c) 2018-2023 Mitchell Rosen, Travis Staton
maintainer:
    Mitchell Rosen <mitchellwrosen@gmail.com>, Travis Staton <hello@travisstaton.com>

author:               Mitchell Rosen, Travis Staton
homepage:             https://github.com/awkward-squad/text-ansi
synopsis:             Text styling for ANSI terminals.
description:
    Text styling for ANSI terminals using SGR codes, as defined by the
    <https://www.ecma-international.org/publications-and-standards/standards/ecma-48 ECMA-48>
    standard.

    Supports foreground\/background color, bold\/faint intensity, italic,
    single\/double underline, strikethrough, frame, encircle, and overline escape
    sequences. Some styles may not work on your terminal.

    Also features terminal detection, so redirecting styled output to a file will
    automatically strip the ANSI escape sequences.

category:             Data
abi:                  f588f568b811632f34098a7174997377
exposed:              True
exposed-modules:
    String.ANSI Text.ANSI Text.Builder.ANSI Text.Lazy.Builder.ANSI

import-dirs:          /usr/lib/ghc-9.4.8/site-local/text-ansi-0.3.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/text-ansi-0.3.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/text-ansi-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-text-ansi
hs-libraries:         HStext-ansi-0.3.0.1-I9GwyqPMgH1LmHNz6r7fu0
depends:
    base-4.17.2.1 text-2.0.2
    text-builder-linear-0.1.3-CFMEGW0KOC1369v90caSM1

haddock-interfaces:   /usr/share/doc/haskell-text-ansi/html/text-ansi.haddock
haddock-html:         /usr/share/doc/haskell-text-ansi/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

