#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tls
version:              2.0.6
visibility:           public
id:                   tls-2.0.6-Fdad12UmwzF9uucfftOruN
key:                  tls-2.0.6-Fdad12UmwzF9uucfftOruN
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           Kazu Yamamoto <kazu@iij.ad.jp>
author:               Vincent Hanquez <vincent@snarc.org>
homepage:             https://github.com/haskell-tls/hs-tls
synopsis:             TLS protocol native implementation
description:
    Native Haskell TLS 1.2/1.3 protocol implementation for servers and clients.

category:             Network
abi:                  e3f3e94bf344f58a608d5dbb74426861
exposed:              True
exposed-modules:
    Network.TLS Network.TLS.Cipher Network.TLS.Compression
    Network.TLS.Extra Network.TLS.Extra.Cipher Network.TLS.Extra.FFDHE
    Network.TLS.Internal Network.TLS.QUIC

hidden-modules:
    Network.TLS.Struct Network.TLS.Struct13 Network.TLS.Core
    Network.TLS.Context Network.TLS.Context.Internal
    Network.TLS.Credentials Network.TLS.Backend Network.TLS.Crypto
    Network.TLS.Crypto.DH Network.TLS.Crypto.IES
    Network.TLS.Crypto.Types Network.TLS.ErrT Network.TLS.Extension
    Network.TLS.Handshake Network.TLS.Handshake.Certificate
    Network.TLS.Handshake.Client
    Network.TLS.Handshake.Client.ClientHello
    Network.TLS.Handshake.Client.Common
    Network.TLS.Handshake.Client.ServerHello
    Network.TLS.Handshake.Client.TLS12
    Network.TLS.Handshake.Client.TLS13 Network.TLS.Handshake.Common
    Network.TLS.Handshake.Common13 Network.TLS.Handshake.Control
    Network.TLS.Handshake.Key Network.TLS.Handshake.Process
    Network.TLS.Handshake.Random Network.TLS.Handshake.Server
    Network.TLS.Handshake.Server.ClientHello
    Network.TLS.Handshake.Server.ClientHello12
    Network.TLS.Handshake.Server.ClientHello13
    Network.TLS.Handshake.Server.Common
    Network.TLS.Handshake.Server.ServerHello12
    Network.TLS.Handshake.Server.ServerHello13
    Network.TLS.Handshake.Server.TLS12
    Network.TLS.Handshake.Server.TLS13 Network.TLS.Handshake.Signature
    Network.TLS.Handshake.State Network.TLS.Handshake.State13
    Network.TLS.Hooks Network.TLS.IO Network.TLS.Imports
    Network.TLS.KeySchedule Network.TLS.MAC Network.TLS.Measurement
    Network.TLS.Packet Network.TLS.Packet13 Network.TLS.Parameters
    Network.TLS.PostHandshake Network.TLS.Record
    Network.TLS.Record.Disengage Network.TLS.Record.Engage
    Network.TLS.Record.Layer Network.TLS.Record.Reading
    Network.TLS.Record.Writing Network.TLS.Record.State
    Network.TLS.Record.Types Network.TLS.RNG Network.TLS.State
    Network.TLS.Session Network.TLS.Sending Network.TLS.Receiving
    Network.TLS.Util Network.TLS.Util.ASN1
    Network.TLS.Util.Serialization Network.TLS.Types Network.TLS.Wire
    Network.TLS.X509

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tls-2.0.6
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tls-2.0.6
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tls-2.0.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tls
hs-libraries:         HStls-2.0.6-Fdad12UmwzF9uucfftOruN
depends:
    asn1-encoding-0.9.6-9t58293E83TLF4D7MJhRyD
    asn1-types-0.3.4-CZ8FC2wBb7x72hegasMid7
    async-2.2.5-3On0Vdlc3urBKBpRPAboKf base-4.17.2.1
    base16-bytestring-1.0.2.0-HnopC1pBvWk9dgrypuG55K
    bytestring-0.11.5.3 cereal-0.5.8.3-H9MXf6i1TMkEAfnsx4oYbT
    crypton-1.0.2-DulODFZwpTEB0ZStV9RIwJ
    crypton-x509-1.7.7-AXX8rIHACGuBEh2uZt02nK
    crypton-x509-store-1.6.10-4MfVQqgftraCc9PME04XAb
    crypton-x509-validation-1.6.13-6qhOcMIobHWKajQmHuZesH
    data-default-class-0.1.2.1-J2UCuIureY5CbnU1SgrtGb
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt mtl-2.2.2
    network-3.1.4.0-L5Z9Li45X29DmnCadSsbZW
    serialise-0.2.6.1-EDYpgETWrrFL7dQg2Da7xh transformers-0.5.6.2
    unix-time-0.4.17-9fHdL2ArMbrJICOAGxTsok

haddock-interfaces:   /usr/share/doc/haskell-tls/html/tls.haddock
haddock-html:         /usr/share/doc/haskell-tls/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

