#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tree-diff
version:              0.3.0.1
visibility:           public
id:                   tree-diff-0.3.0.1-ILSaTTF0qLEAWSpnCxYtsm
key:                  tree-diff-0.3.0.1-ILSaTTF0qLEAWSpnCxYtsm
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  389fa666e097f7cb2451fc84d33bd9d4
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tree-diff
hs-libraries:         HStree-diff-0.3.0.1-ILSaTTF0qLEAWSpnCxYtsm
depends:
    QuickCheck-2.15.0.1-KOgxsDPQQ5yBOLUqP0mecl
    aeson-2.1.2.1-56YME0rnoff9HEf3dDitk2
    ansi-terminal-1.0.2-D5qYwqv6rV8C8VJ5M6PJzO
    ansi-wl-pprint-1.0.2-6ZruWzy2OrY4CuuKUaee2O base-4.17.2.1
    base-compat-0.13.1-8jgXJjtFto7AX0ry1QXDcA bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.0
    hashable-1.4.4.0-7d9WFDaK31uHgEwdYM8cSb parsec-3.1.16.1
    parsers-0.12.12-96TAO08wqwjKaheNsS5gML pretty-1.1.3.6
    primitive-0.9.1.0-2TXcUIi8rPN1Wdwcs7XGaB
    scientific-0.3.8.0-6cXdeLWNyVuBHCExgz4Uaq
    semialign-1.3.1-7OFNG09W0MbEXHg06Yq8y3
    strict-0.5-Bk0it7N8nfVAyVks0BAhAw
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C text-2.0.2
    these-1.2.1-LQhuUu0ja8DKZHwfXvh1eg time-1.12.2
    unordered-containers-0.2.20-90liAnN3BtD8VAzg2AGnlq
    uuid-types-1.0.6-BvW4m4rXhbrBXQuUegqxN1
    vector-0.13.2.0-Fx80VLFrFKz3Sy2krWU8Ue

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

