#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tree-diff
version:              0.3.0.1
visibility:           public
id:                   tree-diff-0.3.0.1-6EiKzsSdf1w8UIhGZDg9pk
key:                  tree-diff-0.3.0.1-6EiKzsSdf1w8UIhGZDg9pk
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  073e2eb93547feb1ec9c2cb94ef93d9a
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tree-diff
hs-libraries:         HStree-diff-0.3.0.1-6EiKzsSdf1w8UIhGZDg9pk
depends:
    QuickCheck-2.15.0.1-KEw9aoMxM6q6i8cfYYug2V
    aeson-2.1.2.1-F8ZePgr6g4xL6kF4wsQx0x
    ansi-terminal-1.0.2-vFVvoY6zrCCEYOqozRT68
    ansi-wl-pprint-1.0.2-7M8cm5Is6oWBg2Lz62bFcn base-4.17.2.1
    base-compat-0.13.1-8jgXJjtFto7AX0ry1QXDcA bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.0
    hashable-1.4.5.0-FUZ3820cmTgAr6H2g2EQN7 parsec-3.1.16.1
    parsers-0.12.12-CP6LBikNQKS17FzgtuptQU pretty-1.1.3.6
    primitive-0.9.1.0-CwYB76NvKpqXNq7rVKe89
    scientific-0.3.8.0-IrrbGrT9lim10QS5UtlqtE
    semialign-1.3.1-E9oyGc0KTLE1lZp9G2Shdi
    strict-0.5-9BjRtln0VdM6QQSpsGmB4a
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C text-2.0.2
    these-1.2.1-CshdovVMeun6vewnGqkSPs time-1.12.2
    unordered-containers-0.2.20-I3GOf8berWn8tol6ImoSEe
    uuid-types-1.0.6-1cjjiQgFLzL6lLsdFHJBaX
    vector-0.13.2.0-7bZcynEBhMGLMgNICkU4Wg

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

