#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-3wMnXYwD4NGDsE8UsMkkJr
key:                  trifecta-2.1.4-3wMnXYwD4NGDsE8UsMkkJr
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  c056a961f2e0f32821fd34f55bdae7ba
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-3wMnXYwD4NGDsE8UsMkkJr
depends:
    ansi-terminal-1.0.2-5q6RGAEXM9Iu4g3iI1aX2 array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.3-BgDmm9LLPQj70kDL41wf1H
    blaze-html-0.9.2.0-K8M4IXmnpCY52d5b9W0uq7
    blaze-markup-0.8.3.0-Hw82R3dN1AH6upDgw0RHOk bytestring-0.11.5.3
    charset-0.3.12-BTnD1pNGNL8KhLnLhe5mLK
    comonad-5.0.9-FYFp3piv5hy78OOCKg42iq containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-KRcPnrnvDmoBU7WVOLymEP
    ghc-prim-0.9.1 hashable-1.4.4.0-1zcla4qwUGf6ADT5z5m7Nb
    indexed-traversable-0.1.4-1jVJAb9Ott1EiIUD50SH50
    lens-5.3-19xvEa7xEEwAXxlwKeJj3v mtl-2.2.2
    parsers-0.12.12-GqMDnuggILO27d7nc6UU3m
    prettyprinter-1.7.1-1debP0Fsl3J1yTjeZdDCQh
    prettyprinter-ansi-terminal-1.1.3-IvvX5ElDgKJ4OQRHTThyNf
    profunctors-5.6.3-L21qmF9iXw2FcRafgVQ9Hj
    reducers-3.12.5-Ez1Y2J8Ez3IFzuusZzMAI1 transformers-0.5.6.2
    unordered-containers-0.2.20-5ChD9TF8iAH5uLARI0QLMz
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

