#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-E70qPHBSw0rIdDVxMcIkBF
key:                  trifecta-2.1.4-E70qPHBSw0rIdDVxMcIkBF
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  d6ae1dd3c15f1e13bfd0adc98fae30d5
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-E70qPHBSw0rIdDVxMcIkBF
depends:
    ansi-terminal-1.0.2-GMfU0IJ80BpJLoxPRZMG7V array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.3-39A5K3QYh9Q4Wd83J8f6EY
    blaze-html-0.9.2.0-Bv8614wD5Ai8TMb1zcEXer
    blaze-markup-0.8.3.0-B1HCckPc2PmDZdNSEMeP4u bytestring-0.11.5.3
    charset-0.3.12-LkBJskzGIvl2m0JhPMM7AP
    comonad-5.0.9-Er3eq4gTywwJing4fQLPZd containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-5ECHuAc2G734JDLQlSoxEJ
    ghc-prim-0.9.1 hashable-1.4.4.0-9uPnQxUdwOnCZlD9EiHqMs
    indexed-traversable-0.1.4-GRWI01OF8Y0Lwm8Qck38KL
    lens-5.3-LWObp7pQkqo7IU7mPMlzlm mtl-2.2.2
    parsers-0.12.12-JYJq89eNa6TDPMBJo3uKrQ
    prettyprinter-1.7.1-OSddR9QU1LKvWd60o7pju
    prettyprinter-ansi-terminal-1.1.3-32HfLtjcgVL9wxVBnHPent
    profunctors-5.6.3-Awvi78GiKWR1SSMXJ32bHl
    reducers-3.12.5-GqFx8i2XgUnAn499viDc8l transformers-0.5.6.2
    unordered-containers-0.2.20-3iRUctzIz2JCUYhLp7SKku
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

