#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-163V94pw1pJ91PeEoZVqM6
key:                  trifecta-2.1.4-163V94pw1pJ91PeEoZVqM6
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  234aa943db2f69b33db478796492e817
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-163V94pw1pJ91PeEoZVqM6
depends:
    ansi-terminal-1.0.2-7CE1Q1IrIunJWV5ocxl3bT array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.3-6IYx8eSaGHUJnwII0Up24j
    blaze-html-0.9.2.0-CEkKMUgjtImLS90A9xKxYe
    blaze-markup-0.8.3.0-17QykfUEWMIHQbmUxmXWOG bytestring-0.11.5.3
    charset-0.3.12-KzqhVhWPUaDCbwWBgqzaF5
    comonad-5.0.9-WdRIGdTjRI2TeSrvZ2o2 containers-0.6.7 deepseq-1.4.8.0
    fingertree-0.1.6.2-2RUDyTmhwQ11Fa87sZ49DB ghc-prim-0.9.1
    hashable-1.4.4.0-Bi9h4Si3Ui62sqHmMmGfiv
    indexed-traversable-0.1.4-5brgCLr4DzwBTCqX62RvHo
    lens-5.3-4nRD5AeUZ87C7qubjFyG6H mtl-2.2.2
    parsers-0.12.12-A4L4eJbdWoQ48Bl9Aan7g7
    prettyprinter-1.7.1-HfOhWgFDXrQ8Fhf8BimOva
    prettyprinter-ansi-terminal-1.1.3-A1yMFsmhb7lBpUsDgDXiNV
    profunctors-5.6.3-KQSjYECC9ooGQWXQlWDirn
    reducers-3.12.5-B7kYPhXRa843iB4bZ9j0uA transformers-0.5.6.2
    unordered-containers-0.2.20-3czZ5Len2GTFaAkRxFZe7E
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

