#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-KTPGDgp32PC9TKRxxdmOJy
key:                  trifecta-2.1.4-KTPGDgp32PC9TKRxxdmOJy
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  9eb56ad1c5007e0a406430cfa91c160f
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-KTPGDgp32PC9TKRxxdmOJy
depends:
    ansi-terminal-1.0.2-tIaEKtcHqOD2jCqJ7RqTi array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4-Lx3iAaL3SPqLsOeZbYO5TI
    blaze-html-0.9.2.0-6qRmvU75P7Y4rwuconQelG
    blaze-markup-0.8.3.0-HOvk3sClrAvE2E2UKocwxZ bytestring-0.11.5.3
    charset-0.3.12-DuvHUrdMzjFL809zUNDFcM
    comonad-5.0.9-4xZxPTI7dTXKSg6ykFjIkS containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-G4lCTwYHm9FB3JKTUhg9Vl
    ghc-prim-0.9.1 hashable-1.4.4.0-D3m6G7BPJON5VQ2FLdROoK
    indexed-traversable-0.1.4-HSZPVrJnBqe50DNrlM74QR
    lens-5.3.1-EJGBiJ62DpEHaBgUJVPkQg mtl-2.2.2
    parsers-0.12.12-D0YRcz3Yn6T9VYHg8av9Pn
    prettyprinter-1.7.1-5ZQmBmwWcWI11K7a8GbhBl
    prettyprinter-ansi-terminal-1.1.3-BBtZEBIElqGhweUz6FSLq
    profunctors-5.6.3-NWHjCvZ9ZmIe3xLFfwZqp
    reducers-3.12.5-1s7wF9uW38LLF84BTCXQ6D transformers-0.5.6.2
    unordered-containers-0.2.20-3371VA61Be1CojVrkG24uM
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

