#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-AbKW9wSHByUElsPtc0SHXQ
key:                  trifecta-2.1.4-AbKW9wSHByUElsPtc0SHXQ
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  74ca704acb18caff2a7b357e2629d316
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-AbKW9wSHByUElsPtc0SHXQ
depends:
    ansi-terminal-1.0.2-HptUcAgyCR58cokR0SMdxn array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4-Gh6rEHJafIhAfZSJRfxA4Z
    blaze-html-0.9.2.0-DBNekIonl9ZHQcEIbEIyEL
    blaze-markup-0.8.3.0-5kCUxopfmLw19aMzBuNGN4 bytestring-0.11.5.3
    charset-0.3.12-95xlffAkGmeDMIENJB6eeO
    comonad-5.0.9-BwSgGbEK8HU1NmS9v2nuKD containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-C8xc13yHUHACHoYmNi8GvU
    ghc-prim-0.9.1 hashable-1.4.4.0-AFqmlTE0BBaCoTGEV5znl2
    indexed-traversable-0.1.4-C3JpN7YDWmy6ZJ7hWVfhAu
    lens-5.3.1-JV4NgTTRRUD4MjO8VGr2iB mtl-2.2.2
    parsers-0.12.12-DfQ8JE6XFwnCtItVAIGDwE
    prettyprinter-1.7.1-5cxpZ3jZU7h3nFjq43pkKP
    prettyprinter-ansi-terminal-1.1.3-DOKqyPGKM8ODcj1VptIqod
    profunctors-5.6.3-CZGRj4axmFA9bHsS9eciFX
    reducers-3.12.5-DnHZlLmpbcYBv3N20Z5mHq transformers-0.5.6.2
    unordered-containers-0.2.20-ASGEyX3xTBf3ZK5sYSGlF8
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

