#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-GoqewgS4JZX540zWG15ybH
key:                  trifecta-2.1.4-GoqewgS4JZX540zWG15ybH
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  f2c74dbfc0fea859366f211904c1a79a
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-GoqewgS4JZX540zWG15ybH
depends:
    ansi-terminal-1.0.2-8A8xJnPl6su1eTYW5nsKkX array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4-Ex2IiKzN8lmx2tekDbDoI
    blaze-html-0.9.2.0-I1J4WDLs4OzIRmd3PXN4gO
    blaze-markup-0.8.3.0-4HZGqC4yhQJ7kzfFmo57xw bytestring-0.11.5.3
    charset-0.3.12-JJTpbku92YyIuZkIRg1lpD
    comonad-5.0.9-EwmOc9SofZq4dnjcvAAX9D containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-DrL6cgYUMhRBCZ4wJNTOes
    ghc-prim-0.9.1 hashable-1.4.4.0-GlxcJ9XR4pRDbsSt4txSan
    indexed-traversable-0.1.4-6pCmebCJxsJJEjw4pmJbeU
    lens-5.3.1-3xUapfELCfEGdnQj2vbjr4 mtl-2.2.2
    parsers-0.12.12-53xTBdi59lo9R6pKoutq7F
    prettyprinter-1.7.1-GvA4HkORFFfEAfVfftDbx5
    prettyprinter-ansi-terminal-1.1.3-HlEqsxZMjvBXkYPY2xpN5
    profunctors-5.6.3-2LK7nm52yOQFV8ojOctBk5
    reducers-3.12.5-4ixfh1DEPgpH44Rdg4Shkd transformers-0.5.6.2
    unordered-containers-0.2.20-3ZBRQjn1NdW5zFXXpEAC63
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

