#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-IWALZ9hMVuO7TDRArD1XzD
key:                  trifecta-2.1.4-IWALZ9hMVuO7TDRArD1XzD
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  0a11aab3063e0ed9491964fcfbdeaaaf
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-IWALZ9hMVuO7TDRArD1XzD
depends:
    ansi-terminal-1.0.2-EWRmoRkCD6N8oQC0Fs2AaT array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4-4SWbbNyka061tgppH7HvSN
    blaze-html-0.9.2.0-DybkQGKrSyk6JOAprz1r5T
    blaze-markup-0.8.3.0-FFIe9nHGnn2LbV2liT8TRJ bytestring-0.11.5.3
    charset-0.3.12-DMlSrfaBOqD3bVDTYCjEJr
    comonad-5.0.9-3BOJDhmiF2e2xz6qIcWk7q containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-4wDeDlQlNonFktVjgzyXqR
    ghc-prim-0.9.1 hashable-1.4.4.0-DGEtQXeqhKmCCbhJMtBsUM
    indexed-traversable-0.1.4-6f7QMxxVa65AkebUdOFXN5
    lens-5.3.1-2DX9LGrXssTCTVwrYJIT9U mtl-2.2.2
    parsers-0.12.12-KT1zX2Z2JCjBCXtK2sgcLk
    prettyprinter-1.7.1-HbDxqL4Ls6KKY7PcGY4CHy
    prettyprinter-ansi-terminal-1.1.3-DVtjKg8pjPJuxhGKChdBp
    profunctors-5.6.3-3Hw57QUNqBl78NHz8f1hTZ
    reducers-3.12.5-9XWeiLddMDcBoLG7KeRGks transformers-0.5.6.2
    unordered-containers-0.2.20-8Q4WKXtMGLf6eJrIPiNhPJ
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

