#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-JnBDr5OknIHELsyfXdZbb4
key:                  trifecta-2.1.4-JnBDr5OknIHELsyfXdZbb4
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  75c7cbd73490a304e87eb5104b37c3d5
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-JnBDr5OknIHELsyfXdZbb4
depends:
    ansi-terminal-1.0.2-ELflFHQZXI14MtzKLMv1G6 array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4-8DNZG0v2dXo77KXKrz7TGj
    blaze-html-0.9.2.0-KGNUVzd5sBrDaiavnWufWj
    blaze-markup-0.8.3.0-BQHgx8yAxJB0rzkVyHbGy bytestring-0.11.5.3
    charset-0.3.12-B2trbwqk32hCVySlQSEFZd
    comonad-5.0.9-KL2ihI7AlOUDBvPwPO9F7m containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-DDCdDkMdrSjD2rI9vZMZ1N
    ghc-prim-0.9.1 hashable-1.4.4.0-KHdv63hvW7JkoOGsLWKac
    indexed-traversable-0.1.4-3V8UCsCL2nP2CArv2W49N1
    lens-5.3.1-6s7OGBiqW0t1WJAI91dKgc mtl-2.2.2
    parsers-0.12.12-F1EbyLFKjurFIdX9vYicqL
    prettyprinter-1.7.1-K25tjwTKXuP4KBelsyCegB
    prettyprinter-ansi-terminal-1.1.3-1B0Gr63y68dtMIFWWuAl2
    profunctors-5.6.3-Al90cA0rHhQB7urjPM7Mrc
    reducers-3.12.5-HumCxnTCIWc8NVUYLTly5s transformers-0.5.6.2
    unordered-containers-0.2.20-1i1FNKzvn6TI2R1AzcNrcz
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

