#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-57e6Xvv1Wz815Ca40lK6np
key:                  trifecta-2.1.4-57e6Xvv1Wz815Ca40lK6np
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  6f8a29459a53cb15398b5ffb65040283
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-57e6Xvv1Wz815Ca40lK6np
depends:
    ansi-terminal-1.0.2-HjENL9BIUVI6RnTwgiyfuy array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4-IUOXk9qX0ZPB9EabAhi3MJ
    blaze-html-0.9.2.0-LlU0XfzVpg34MJkFx2EZcl
    blaze-markup-0.8.3.0-Jmy6mhQ8sFNHEauj2dm6FF bytestring-0.11.5.3
    charset-0.3.12-4PkRHl5spZz65cNzbpOLqs
    comonad-5.0.9-KmJkpLSdReI12tQs8mabiu containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-4MFMFPkCVifIkKsaaTXfzI
    ghc-prim-0.9.1 hashable-1.4.4.0-EdBgVbn6YIuE9bA3dwmz04
    indexed-traversable-0.1.4-I4BD8iHmRbP9SiNqQBAmeX
    lens-5.3.1-39Rj9LQQhPID4B1jmyDMFk mtl-2.2.2
    parsers-0.12.12-408Ysx6ZjoH8ZyaqBXF8rY
    prettyprinter-1.7.1-7LCr279S4u97FneESew6z
    prettyprinter-ansi-terminal-1.1.3-9QGQBbp5h95K5T1zzYNOLO
    profunctors-5.6.3-J6y4iD5C6dqAks6U9gKtk4
    reducers-3.12.5-5bAJ6Smjqfd69cPIiYFyCI transformers-0.5.6.2
    unordered-containers-0.2.20-8cMd7edANcDBeBDjVdjsZY
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

