#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-8gjQaTM19g69J9g2B5x2Yc
key:                  trifecta-2.1.4-8gjQaTM19g69J9g2B5x2Yc
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  9a33f3b05b033affb794df8485584f2e
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-8gjQaTM19g69J9g2B5x2Yc
depends:
    ansi-terminal-1.0.2-22xggRH3qa0GcEZ754vdyz array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4-LwgH2lQg9UbBZKk19Yi6xR
    blaze-html-0.9.2.0-8gAdghBONCL3ZB7TziE9DG
    blaze-markup-0.8.3.0-K0gPqNPIa919e3jk3QPSeV bytestring-0.11.5.3
    charset-0.3.12-J6u8bmY1rYX2dwanJtyTNR
    comonad-5.0.9-L49X9Y5t2yvI3487EW3XwY containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-Ci2cpvaD4NfAvj4MMNB1Pi
    ghc-prim-0.9.1 hashable-1.4.4.0-32D8TF68xTpFTCUtV1slOl
    indexed-traversable-0.1.4-FUUuMGYQ6soDzHvrIh7KUw
    lens-5.3.1-Hr3CNVd7aJGEq0oCRlwS0q mtl-2.2.2
    parsers-0.12.12-FeDsK74ZKVnKzsYPDMhAKA
    prettyprinter-1.7.1-BBXLTkLEQRl40uOvW3t4pw
    prettyprinter-ansi-terminal-1.1.3-33kZdcwyY5M8HtWIXW1CoT
    profunctors-5.6.3-KX2EIyoit6HH68OSd7rf0q
    reducers-3.12.5-2mc6xrdHrxf1h45TZBgR24 transformers-0.5.6.2
    unordered-containers-0.2.20-AhSAKQoMQ97FOa03PWrXZ
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

