#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-JlyCZGRLlIO7FGKwyzqznK
key:                  trifecta-2.1.4-JlyCZGRLlIO7FGKwyzqznK
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  b333566939e8c2a2e5fae359e45403fa
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-JlyCZGRLlIO7FGKwyzqznK
depends:
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4-B5FT87wlflF4r5SJ13FU3M
    blaze-html-0.9.2.0-Flt3Tc7vZ1qFeyjyRV9cWw
    blaze-markup-0.8.3.0-2V3MXZdaeBa5lesIVE9nmc bytestring-0.11.5.3
    charset-0.3.12-299QbnexLUOIXEFwHyhDxj
    comonad-5.0.9-F3uF2UZEfOQ4mXlrEuQWeg containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-FWWdk8WpEFt29f63Apiz6s
    ghc-prim-0.9.1 hashable-1.4.4.0-6tleuNdu8X41J3b2E1oOOY
    indexed-traversable-0.1.4-FjrZ8c6UpDNGZqVYWjmd91
    lens-5.3.1-1dHHf9jtSMJ2j1NVow6adv mtl-2.2.2
    parsers-0.12.12-4yPBovHI6Gs3s5A8NPgJkW
    prettyprinter-1.7.1-Da1BCiI1NV6LfdDEPEDf77
    prettyprinter-ansi-terminal-1.1.3-JvMlFweUqjX9cwpH0vA579
    profunctors-5.6.3-FiHazNoTbSuEkaVv0xHC9t
    reducers-3.12.5-54KRC0ucp1B4RYUdFJQV00 transformers-0.5.6.2
    unordered-containers-0.2.20-Eo1ocpXri5ABLOF81VToPu
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

