#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-1jMfV9x3tXd7A1MhO88TUe
key:                  trifecta-2.1.4-1jMfV9x3tXd7A1MhO88TUe
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  649a1676a36d489278e08b29e791d7e2
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-1jMfV9x3tXd7A1MhO88TUe
depends:
    ansi-terminal-1.0.2-7enoCfAnx2SGJDVGgMW6rt array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-20XIpZGgNDfHegCCnMhzZO
    blaze-html-0.9.2.0-GSQGyEfgR96HA14H2zM96E
    blaze-markup-0.8.3.0-L6t6v2gy37n7wxr3axaBPf bytestring-0.11.5.3
    charset-0.3.12-1cNpbX4I446DDL2y4TzNxA
    comonad-5.0.9-KR1yWuXYZs84UY5BP3dDYm containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-Ls26iZ5yxaMC5VMnUeYOwm
    ghc-prim-0.9.1 hashable-1.4.5.0-DrXzgEMDRcV8gNOMGO5wPZ
    indexed-traversable-0.1.4-CjelN0MuLjgFb4a6UstzaC
    lens-5.3.1-2VSC1EMe0UsGg1l2wcItEv mtl-2.2.2
    parsers-0.12.12-4Avmhnq4mpdAan7s2Mf6Hi
    prettyprinter-1.7.1-80F1dUtwFWzDp5CT3ZZVKz
    prettyprinter-ansi-terminal-1.1.3-IaiwJGU5h7gDXHX3Nxd5K0
    profunctors-5.6.3-HTsznkqhEwsHeSfrzIpeM4
    reducers-3.12.5-8hWUDRiXm9HDhh4Ga077cq transformers-0.5.6.2
    unordered-containers-0.2.20-FLM1pZb3BI5FpyNo5sVXNv
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

