#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-D46tW4NCT1y9c5yqhHLob3
key:                  trifecta-2.1.4-D46tW4NCT1y9c5yqhHLob3
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  2881334b52a4ac7cdb7b085e5eaf8190
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-D46tW4NCT1y9c5yqhHLob3
depends:
    ansi-terminal-1.0.2-vFVvoY6zrCCEYOqozRT68 array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-9PaZF0E1n1UJak5ze95yxX
    blaze-html-0.9.2.0-Hmx0qDwpXdTINSADNpvYjl
    blaze-markup-0.8.3.0-3B7X73TXz7h4xBgQnwPnu3 bytestring-0.11.5.3
    charset-0.3.12-5Jwo1nd6KX98tGJHcNo8KB
    comonad-5.0.9-CtqckwEYhoSABJxUI75K1B containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-sfsUmtIDV1A59av3dM71Y
    ghc-prim-0.9.1 hashable-1.4.5.0-FUZ3820cmTgAr6H2g2EQN7
    indexed-traversable-0.1.4-8RoXG5saZErHeqMhoihF0x
    lens-5.3.1-FP95Rv35No71PYJue58Hxp mtl-2.2.2
    parsers-0.12.12-CP6LBikNQKS17FzgtuptQU
    prettyprinter-1.7.1-AIJZZXuo91NCViNpmKNzcQ
    prettyprinter-ansi-terminal-1.1.3-zpJIE64fpCIqSqesY8J9j
    profunctors-5.6.3-E7SG9Hl6BYsG0p6cuC3G7G
    reducers-3.12.5-17cpnX3R3SuDJwRH6kMc2K transformers-0.5.6.2
    unordered-containers-0.2.20-I3GOf8berWn8tol6ImoSEe
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

