#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-2tsA7SADz8pIDhP8hbcpgb
key:                  trifecta-2.1.4-2tsA7SADz8pIDhP8hbcpgb
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  a311e36aa9b74a98e3d5e9910aa11000
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-2tsA7SADz8pIDhP8hbcpgb
depends:
    ansi-terminal-1.0.2-4v7foyTOWos7vsV6BCUMgI array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-BSmLbvNejToLEWeTg2SNQj
    blaze-html-0.9.2.0-Cv5u1eWpWkgLQ3EG0vDZlF
    blaze-markup-0.8.3.0-CsF5JFEey9Z78NugLbJTVe bytestring-0.11.5.3
    charset-0.3.12-HiedclOG9JZ4ax86AoHsET
    comonad-5.0.9-9ngCkSDh5y9BpyY9uXawb containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-BLEGJgqNPjA8kEqK0OkApG
    ghc-prim-0.9.1 hashable-1.4.5.0-EMf4Iv4OllUGRj72K4SCf0
    indexed-traversable-0.1.4-HEP7TGiK1hWFsWJfrW3hPw
    lens-5.3.1-ph5gK6GMHDK3KRhjZ6UP9 mtl-2.2.2
    parsers-0.12.12-KExJse5L7Lp2PoqRl67KBV
    prettyprinter-1.7.1-Akkp0WpHSIjZLnKQ6G5af
    prettyprinter-ansi-terminal-1.1.3-CospziYmNkwAY8CNK8Zl1h
    profunctors-5.6.3-5ykNj0b49W3C5puCJKHDiE
    reducers-3.12.5-26moGXtENUQ3CjexNnRj7J transformers-0.5.6.2
    unordered-containers-0.2.20-L410VxfvorQ5RMb8wocThG
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

