#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-96QeSzcZhtZ7FrP6JyTiMk
key:                  trifecta-2.1.4-96QeSzcZhtZ7FrP6JyTiMk
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  fe1416d4632ea895b7518a65932d7993
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-96QeSzcZhtZ7FrP6JyTiMk
depends:
    ansi-terminal-1.0.2-5rU4pkSh0boE3ReNmRQ6hH array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-DgY6tTFllLSJs99PsEwYfH
    blaze-html-0.9.2.0-Irz9BEYJh8t6ttuT8sjDNM
    blaze-markup-0.8.3.0-vIyaH4vY5i1DL0t3Gsy7s bytestring-0.11.5.3
    charset-0.3.12-6OEadX9krNv3KpL5BmKv96
    comonad-5.0.9-MFS5PgWnjFIRKFuSaGcP9 containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-Gs4U3SHjBTgEAmie1O74vF
    ghc-prim-0.9.1 hashable-1.4.6.0-2vEivDIcaMF9mfkC7wRjoU
    indexed-traversable-0.1.4-JYfisWLMyBh1BEfbVJsUp6
    lens-5.3.2-2jnRf5jwH3ZB3yflks8aAl mtl-2.2.2
    parsers-0.12.12-Fj33ZbpVKfRD9IdEYNnRB5
    prettyprinter-1.7.1-C4D8Xe0aGZX68OnrHcEg7p
    prettyprinter-ansi-terminal-1.1.3-H5jyEdPwAJmJs5Pvu8T89u
    profunctors-5.6.3-DOaMJJlR1YuKGt9MktGoyP
    reducers-3.12.5-EYzIn0egrhGLxOQgbMNRVk transformers-0.5.6.2
    unordered-containers-0.2.20-8z8yrOH3Dwd8Gc78vZRE2k
    utf8-string-1.0.2-6nfZpgw1Ffy3MDnMPT0XX9

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

